/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskController;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.ConfigurableProducerWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.FlushGenerator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.ThroughputGenerator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.workload.TopicsSpec;

public class ConfigurableProducerSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final Optional<FlushGenerator> flushGenerator;
    private final ThroughputGenerator throughputGenerator;
    private final PayloadGenerator keyGenerator;
    private final PayloadGenerator valueGenerator;
    private final Map<String, String> producerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final TopicsSpec activeTopic;
    private final int activePartition;

    @JsonCreator
    public ConfigurableProducerSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="flushGenerator") Optional<FlushGenerator> flushGenerator, @JsonProperty(value="throughputGenerator") ThroughputGenerator throughputGenerator, @JsonProperty(value="keyGenerator") PayloadGenerator keyGenerator, @JsonProperty(value="valueGenerator") PayloadGenerator valueGenerator, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="activeTopic") TopicsSpec activeTopic, @JsonProperty(value="activePartition") int activePartition) {
        super(startMs, durationMs);
        this.producerNode = producerNode == null ? "" : producerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.flushGenerator = flushGenerator;
        this.keyGenerator = keyGenerator;
        this.valueGenerator = valueGenerator;
        this.throughputGenerator = throughputGenerator;
        this.producerConf = this.configOrEmptyMap(producerConf);
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
        this.adminClientConf = this.configOrEmptyMap(adminClientConf);
        this.activeTopic = activeTopic.immutableCopy();
        this.activePartition = activePartition;
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public Optional<FlushGenerator> flushGenerator() {
        return this.flushGenerator;
    }

    @JsonProperty
    public PayloadGenerator keyGenerator() {
        return this.keyGenerator;
    }

    @JsonProperty
    public PayloadGenerator valueGenerator() {
        return this.valueGenerator;
    }

    @JsonProperty
    public ThroughputGenerator throughputGenerator() {
        return this.throughputGenerator;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public TopicsSpec activeTopic() {
        return this.activeTopic;
    }

    @JsonProperty
    public int activePartition() {
        return this.activePartition;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.producerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ConfigurableProducerWorker(id, this);
    }
}

