/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.fault;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common.Node;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common.Platform;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.fault.DegradedNetworkFaultSpec;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegradedNetworkFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(DegradedNetworkFaultWorker.class);
    private final String id;
    private final Map<String, DegradedNetworkFaultSpec.NodeDegradeSpec> nodeSpecs;
    private WorkerStatusTracker status;

    public DegradedNetworkFaultWorker(String id, Map<String, DegradedNetworkFaultSpec.NodeDegradeSpec> nodeSpecs) {
        this.id = id;
        this.nodeSpecs = nodeSpecs;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) throws Exception {
        log.info("Activating DegradedNetworkFaultWorker {}.", (Object)this.id);
        this.status = status;
        this.status.update(new TextNode("enabling traffic control " + this.id));
        Node curNode = platform.curNode();
        DegradedNetworkFaultSpec.NodeDegradeSpec nodeSpec = this.nodeSpecs.get(curNode.name());
        if (nodeSpec != null) {
            for (String device : this.devicesForSpec(nodeSpec)) {
                if (nodeSpec.latencyMs() < 0 || nodeSpec.rateLimitKbit() < 0) {
                    throw new RuntimeException("Expected non-negative values for latencyMs and rateLimitKbit, but got " + nodeSpec);
                }
                this.enableTrafficControl(platform, device, nodeSpec.latencyMs(), nodeSpec.rateLimitKbit());
            }
        }
        this.status.update(new TextNode("enabled traffic control " + this.id));
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating DegradedNetworkFaultWorker {}.", (Object)this.id);
        this.status.update(new TextNode("disabling traffic control " + this.id));
        Node curNode = platform.curNode();
        DegradedNetworkFaultSpec.NodeDegradeSpec nodeSpec = this.nodeSpecs.get(curNode.name());
        if (nodeSpec != null) {
            for (String device : this.devicesForSpec(nodeSpec)) {
                this.disableTrafficControl(platform, device);
            }
        }
        this.status.update(new TextNode("disabled traffic control " + this.id));
    }

    private Set<String> devicesForSpec(DegradedNetworkFaultSpec.NodeDegradeSpec nodeSpec) throws Exception {
        HashSet<String> devices = new HashSet<String>();
        if (nodeSpec.networkDevice().isEmpty()) {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isLoopback()) continue;
                devices.add(networkInterface.getName());
            }
        } else {
            devices.add(nodeSpec.networkDevice());
        }
        return devices;
    }

    private void enableTrafficControl(Platform platform, String networkDevice, int delayMs, int rateLimitKbps) throws IOException {
        if (delayMs > 0) {
            int deviationMs = Math.max(1, (int)Math.sqrt(delayMs));
            ArrayList delay = new ArrayList();
            this.rootHandler(networkDevice, delay::add);
            this.netemDelay(delayMs, deviationMs, delay::add);
            platform.runCommand(delay.toArray(new String[0]));
            if (rateLimitKbps > 0) {
                ArrayList rate = new ArrayList();
                this.childHandler(networkDevice, rate::add);
                this.tbfRate(rateLimitKbps, rate::add);
                platform.runCommand(rate.toArray(new String[0]));
            }
        } else if (rateLimitKbps > 0) {
            ArrayList rate = new ArrayList();
            this.rootHandler(networkDevice, rate::add);
            this.tbfRate(rateLimitKbps, rate::add);
            platform.runCommand(rate.toArray(new String[0]));
        } else {
            log.warn("Not applying any rate limiting or latency");
        }
    }

    private void rootHandler(String networkDevice, Consumer<String> consumer) {
        Stream.of("sudo", "tc", "qdisc", "add", "dev", networkDevice, "root", "handle", "1:0").forEach(consumer);
    }

    private void childHandler(String networkDevice, Consumer<String> consumer) {
        Stream.of("sudo", "tc", "qdisc", "add", "dev", networkDevice, "parent", "1:1", "handle", "10:").forEach(consumer);
    }

    private void netemDelay(int delayMs, int deviationMs, Consumer<String> consumer) {
        Stream.of("netem", "delay", String.format("%dms", delayMs), String.format("%dms", deviationMs), "distribution", "paretonormal").forEach(consumer);
    }

    private void tbfRate(int rateLimitKbit, Consumer<String> consumer) {
        Stream.of("tbf", "rate", String.format("%dkbit", rateLimitKbit), "burst", "1mbit", "latency", "500ms").forEach(consumer);
    }

    private void disableTrafficControl(Platform platform, String networkDevice) throws IOException {
        platform.runCommand(new String[]{"sudo", "tc", "qdisc", "del", "dev", networkDevice, "root"});
    }
}

