/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.common;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringExpander {
    private static final Pattern NUMERIC_RANGE_PATTERN = Pattern.compile("(.*)\\[([0-9]*)\\-([0-9]*)\\](.*)");

    public static HashSet<String> expand(String val) {
        HashSet<String> set = new HashSet<String>();
        Matcher matcher = NUMERIC_RANGE_PATTERN.matcher(val);
        if (!matcher.matches()) {
            set.add(val);
            return set;
        }
        String prequel = matcher.group(1);
        String rangeStart = matcher.group(2);
        String rangeEnd = matcher.group(3);
        String epilog = matcher.group(4);
        int rangeStartInt = Integer.parseInt(rangeStart);
        int rangeEndInt = Integer.parseInt(rangeEnd);
        if (rangeEndInt < rangeStartInt) {
            throw new RuntimeException("Invalid range: start " + rangeStartInt + " is higher than end " + rangeEndInt);
        }
        for (int i = rangeStartInt; i <= rangeEndInt; ++i) {
            set.add(String.format("%s%d%s", prequel, i, epilog));
        }
        return set;
    }
}

