/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.agent;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.agent.Agent;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.DestroyWorkerRequest;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.Empty;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.trogdor.rest.UptimeResponse;

@Path(value="/agent")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AgentRestResource {
    private final AtomicReference<Agent> agent = new AtomicReference<Object>(null);
    @Context
    private ServletContext context;

    public void setAgent(Agent myAgent) {
        this.agent.set(myAgent);
    }

    @GET
    @Path(value="/status")
    public AgentStatusResponse getStatus() throws Throwable {
        return this.agent().status();
    }

    @GET
    @Path(value="/uptime")
    public UptimeResponse uptime() {
        return this.agent().uptime();
    }

    @POST
    @Path(value="/worker/create")
    public Empty createWorker(CreateWorkerRequest req) throws Throwable {
        this.agent().createWorker(req);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/worker/stop")
    public Empty stopWorker(StopWorkerRequest req) throws Throwable {
        this.agent().stopWorker(req);
        return Empty.INSTANCE;
    }

    @DELETE
    @Path(value="/worker")
    public Empty destroyWorker(@DefaultValue(value="0") @QueryParam(value="workerId") long workerId) throws Throwable {
        this.agent().destroyWorker(new DestroyWorkerRequest(workerId));
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/shutdown")
    public Empty shutdown() throws Throwable {
        this.agent().beginShutdown();
        return Empty.INSTANCE;
    }

    private Agent agent() {
        Agent myAgent = this.agent.get();
        if (myAgent == null) {
            throw new RuntimeException("AgentRestResource has not been initialized yet.");
        }
        return myAgent;
    }
}

