/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.util.Callback;

public abstract class ConvertingFutureCallback<U, T>
implements Callback<U>,
Future<T> {
    private final Callback<T> underlying;
    private final CountDownLatch finishedLatch;
    private volatile T result = null;
    private volatile Throwable exception = null;
    private volatile boolean cancelled = false;

    public ConvertingFutureCallback() {
        this(null);
    }

    public ConvertingFutureCallback(Callback<T> underlying) {
        this.underlying = underlying;
        this.finishedLatch = new CountDownLatch(1);
    }

    public abstract T convert(U var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(Throwable error, U result) {
        ConvertingFutureCallback convertingFutureCallback = this;
        synchronized (convertingFutureCallback) {
            if (this.isDone()) {
                return;
            }
            if (error != null) {
                this.exception = error;
            } else {
                this.result = this.convert(result);
            }
            if (this.underlying != null) {
                this.underlying.onCompletion(error, this.result);
            }
            this.finishedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ConvertingFutureCallback convertingFutureCallback = this;
        synchronized (convertingFutureCallback) {
            if (this.isDone()) {
                return false;
            }
            if (mayInterruptIfRunning) {
                this.cancelled = true;
                this.finishedLatch.countDown();
                return true;
            }
        }
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            throw new ConnectException("Interrupted while waiting for task to complete", e);
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.finishedLatch.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.finishedLatch.await();
        return this.result();
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.finishedLatch.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for future");
        }
        return this.result();
    }

    private T result() throws ExecutionException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }
}

