/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage;

import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.ConnectSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.DataException;

public class OffsetUtils {
    public static void validateFormat(Object offsetData) {
        if (offsetData == null) {
            return;
        }
        if (!(offsetData instanceof Map)) {
            throw new DataException("Offsets must be specified as a Map");
        }
        OffsetUtils.validateFormat((Map)offsetData);
    }

    public static <K, V> void validateFormat(Map<K, V> offsetData) {
        if (offsetData == null) {
            return;
        }
        for (Map.Entry<K, V> entry : offsetData.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new DataException("Offsets may only use String keys");
            }
            V value = entry.getValue();
            if (value == null) continue;
            Schema.Type schemaType = ConnectSchema.schemaType(value.getClass());
            if (schemaType == null) {
                throw new DataException("Offsets may only contain primitive types as values, but field " + entry.getKey() + " contains " + value.getClass());
            }
            if (schemaType.isPrimitive()) continue;
            throw new DataException("Offsets may only contain primitive types as values, but field " + entry.getKey() + " contains " + (Object)((Object)schemaType));
        }
    }
}

