/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.CloseableOffsetStorageReader;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.Converter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.OffsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetStorageReaderImpl
implements CloseableOffsetStorageReader {
    private static final Logger log = LoggerFactory.getLogger(OffsetStorageReaderImpl.class);
    private final OffsetBackingStore backingStore;
    private final String namespace;
    private final Converter keyConverter;
    private final Converter valueConverter;
    private final AtomicBoolean closed;
    private final Set<Future<Map<ByteBuffer, ByteBuffer>>> offsetReadFutures;

    public OffsetStorageReaderImpl(OffsetBackingStore backingStore, String namespace, Converter keyConverter, Converter valueConverter) {
        this.backingStore = backingStore;
        this.namespace = namespace;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.closed = new AtomicBoolean(false);
        this.offsetReadFutures = new HashSet<Future<Map<ByteBuffer, ByteBuffer>>>();
    }

    @Override
    public <T> Map<String, Object> offset(Map<String, T> partition) {
        return this.offsets(Collections.singletonList(partition)).get(partition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<Map<String, T>, Map<String, Object>> offsets(Collection<Map<String, T>> partitions) {
        Map<ByteBuffer, ByteBuffer> raw;
        HashMap<ByteBuffer, Map<String, T>> serializedToOriginal = new HashMap<ByteBuffer, Map<String, T>>(partitions.size());
        for (Map<String, T> key : partitions) {
            try {
                OffsetUtils.validateFormat(key);
                byte[] keySerialized = this.keyConverter.fromConnectData(this.namespace, null, Arrays.asList(this.namespace, key));
                ByteBuffer keyBuffer = keySerialized != null ? ByteBuffer.wrap(keySerialized) : null;
                serializedToOriginal.put(keyBuffer, key);
            }
            catch (Throwable t) {
                log.error("CRITICAL: Failed to serialize partition key when getting offsets for task with namespace {}. No value for this data will be returned, which may break the task or cause it to skip some data.", (Object)this.namespace, (Object)t);
            }
        }
        try {
            Future<Map<ByteBuffer, ByteBuffer>> offsetReadFuture;
            Set<Future<Map<ByteBuffer, ByteBuffer>>> t = this.offsetReadFutures;
            synchronized (t) {
                if (this.closed.get()) {
                    throw new ConnectException("Offset reader is closed. This is likely because the task has already been scheduled to stop but has taken longer than the graceful shutdown period to do so.");
                }
                offsetReadFuture = this.backingStore.get(serializedToOriginal.keySet());
                this.offsetReadFutures.add(offsetReadFuture);
            }
            try {
                raw = offsetReadFuture.get();
            }
            catch (CancellationException e) {
                throw new ConnectException("Offset reader closed while attempting to read offsets. This is likely because the task was been scheduled to stop but has taken longer than the graceful shutdown period to do so.");
            }
            finally {
                Set<Future<Map<ByteBuffer, ByteBuffer>>> set = this.offsetReadFutures;
                synchronized (set) {
                    this.offsetReadFutures.remove(offsetReadFuture);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to fetch offsets from namespace {}: ", (Object)this.namespace, (Object)e);
            throw new ConnectException("Failed to fetch offsets.", e);
        }
        HashMap<Map<String, T>, Map<String, Object>> result = new HashMap<Map<String, T>, Map<String, Object>>(partitions.size());
        for (Map.Entry<ByteBuffer, ByteBuffer> rawEntry : raw.entrySet()) {
            try {
                if (!serializedToOriginal.containsKey(rawEntry.getKey())) {
                    log.error("Should be able to map {} back to a requested partition-offset key, backing store may have returned invalid data", (Object)rawEntry.getKey());
                    continue;
                }
                Map origKey = (Map)serializedToOriginal.get(rawEntry.getKey());
                SchemaAndValue deserializedSchemaAndValue = this.valueConverter.toConnectData(this.namespace, rawEntry.getValue() != null ? rawEntry.getValue().array() : null);
                Object deserializedValue = deserializedSchemaAndValue.value();
                OffsetUtils.validateFormat(deserializedValue);
                result.put(origKey, (Map)deserializedValue);
            }
            catch (Throwable t) {
                log.error("CRITICAL: Failed to deserialize offset data when getting offsets for task with namespace {}. No value for this data will be returned, which may break the task or cause it to skip some data. This could either be due to an error in the connector implementation or incompatible schema.", (Object)this.namespace, (Object)t);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            Set<Future<Map<ByteBuffer, ByteBuffer>>> set = this.offsetReadFutures;
            synchronized (set) {
                for (Future<Map<ByteBuffer, ByteBuffer>> offsetReadFuture : this.offsetReadFutures) {
                    try {
                        offsetReadFuture.cancel(true);
                    }
                    catch (Throwable t) {
                        log.error("Failed to cancel offset read future", t);
                    }
                }
                this.offsetReadFutures.clear();
            }
        }
    }
}

