/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.rest.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.connector.Connector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.Herder;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorPluginInfo;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.MockConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.MockSinkConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.MockSourceConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.SchemaSourceConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.VerifiableSinkConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.tools.VerifiableSourceConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.util.FutureCallback;

@Path(value="/connector-plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorPluginsResource {
    private static final String ALIAS_SUFFIX = "Connector";
    private final Herder herder;
    private final List<ConnectorPluginInfo> connectorPlugins;
    private static final List<Class<? extends Connector>> CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSourceConnector.class, VerifiableSinkConnector.class, MockConnector.class, MockSourceConnector.class, MockSinkConnector.class, SchemaSourceConnector.class);

    public ConnectorPluginsResource(Herder herder) {
        this.herder = herder;
        this.connectorPlugins = new ArrayList<ConnectorPluginInfo>();
    }

    @PUT
    @Path(value="/{connectorType}/config/validate")
    public ConfigInfos validateConfigs(@PathParam(value="connectorType") String connType, Map<String, String> connectorConfig) throws Throwable {
        String includedConnType = connectorConfig.get("connector.class");
        if (includedConnType != null && !this.normalizedPluginName(includedConnType).endsWith(this.normalizedPluginName(connType))) {
            throw new BadRequestException("Included connector type " + includedConnType + " does not match request type " + connType);
        }
        FutureCallback<ConfigInfos> validationCallback = new FutureCallback<ConfigInfos>();
        this.herder.validateConnectorConfig(connectorConfig, validationCallback, false);
        try {
            return (ConfigInfos)validationCallback.get(90000L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    @GET
    @Path(value="/")
    public List<ConnectorPluginInfo> listConnectorPlugins() {
        return this.getConnectorPlugins();
    }

    private synchronized List<ConnectorPluginInfo> getConnectorPlugins() {
        if (this.connectorPlugins.isEmpty()) {
            for (PluginDesc<Connector> plugin : this.herder.plugins().connectors()) {
                if (CONNECTOR_EXCLUDES.contains(plugin.pluginClass())) continue;
                this.connectorPlugins.add(new ConnectorPluginInfo(plugin));
            }
        }
        return Collections.unmodifiableList(this.connectorPlugins);
    }

    private String normalizedPluginName(String pluginName) {
        return pluginName.endsWith(ALIAS_SUFFIX) && pluginName.length() > ALIAS_SUFFIX.length() ? pluginName.substring(0, pluginName.length() - ALIAS_SUFFIX.length()) : pluginName;
    }
}

