/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.components.Versioned;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.connector.Connector;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.Converter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.transforms.Transformation;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private static final String CLASSPATH_NAME = "classpath";
    private static final String UNDEFINED_VERSION = "undefined";
    private final Map<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders;
    private final Map<String, String> aliases;
    private final SortedSet<PluginDesc<Connector>> connectors;
    private final SortedSet<PluginDesc<Converter>> converters;
    private final SortedSet<PluginDesc<HeaderConverter>> headerConverters;
    private final SortedSet<PluginDesc<Transformation>> transformations;
    private final SortedSet<PluginDesc<Predicate>> predicates;
    private final SortedSet<PluginDesc<ConfigProvider>> configProviders;
    private final SortedSet<PluginDesc<ConnectRestExtension>> restExtensions;
    private final SortedSet<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies;
    private final List<String> pluginPaths;
    private static final String MANIFEST_PREFIX = "META-INF/services/";
    private static final Class[] SERVICE_LOADER_PLUGINS = new Class[]{ConnectRestExtension.class, ConfigProvider.class};
    private static final Set<String> PLUGIN_MANIFEST_FILES = Arrays.stream(SERVICE_LOADER_PLUGINS).map(serviceLoaderPlugin -> MANIFEST_PREFIX + serviceLoaderPlugin.getName()).collect(Collectors.toSet());

    public DelegatingClassLoader(List<String> pluginPaths, ClassLoader parent) {
        super(new URL[0], parent);
        this.pluginPaths = pluginPaths;
        this.pluginLoaders = new HashMap();
        this.aliases = new HashMap<String, String>();
        this.connectors = new TreeSet<PluginDesc<Connector>>();
        this.converters = new TreeSet<PluginDesc<Converter>>();
        this.headerConverters = new TreeSet<PluginDesc<HeaderConverter>>();
        this.transformations = new TreeSet<PluginDesc<Transformation>>();
        this.predicates = new TreeSet<PluginDesc<Predicate>>();
        this.configProviders = new TreeSet<PluginDesc<ConfigProvider>>();
        this.restExtensions = new TreeSet<PluginDesc<ConnectRestExtension>>();
        this.connectorClientConfigPolicies = new TreeSet<PluginDesc<ConnectorClientConfigOverridePolicy>>();
    }

    public DelegatingClassLoader(List<String> pluginPaths) {
        this(pluginPaths, DelegatingClassLoader.class.getClassLoader());
    }

    public Set<PluginDesc<Connector>> connectors() {
        return this.connectors;
    }

    public Set<PluginDesc<Converter>> converters() {
        return this.converters;
    }

    public Set<PluginDesc<HeaderConverter>> headerConverters() {
        return this.headerConverters;
    }

    public Set<PluginDesc<Transformation>> transformations() {
        return this.transformations;
    }

    public Set<PluginDesc<Predicate>> predicates() {
        return this.predicates;
    }

    public Set<PluginDesc<ConfigProvider>> configProviders() {
        return this.configProviders;
    }

    public Set<PluginDesc<ConnectRestExtension>> restExtensions() {
        return this.restExtensions;
    }

    public Set<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.connectorClientConfigPolicies;
    }

    public PluginClassLoader pluginClassLoader(String name) {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return null;
        }
        SortedMap<PluginDesc<?>, ClassLoader> inner = this.pluginLoaders.get(name);
        if (inner == null) {
            return null;
        }
        ClassLoader pluginLoader = (ClassLoader)inner.get(inner.lastKey());
        return pluginLoader instanceof PluginClassLoader ? (PluginClassLoader)pluginLoader : null;
    }

    public ClassLoader connectorLoader(Connector connector) {
        return this.connectorLoader(connector.getClass().getName());
    }

    public ClassLoader connectorLoader(String connectorClassOrAlias) {
        String fullName = this.aliases.containsKey(connectorClassOrAlias) ? this.aliases.get(connectorClassOrAlias) : connectorClassOrAlias;
        URLClassLoader classLoader = this.pluginClassLoader(fullName);
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Getting plugin class loader: '{}' for connector: {}", (Object)classLoader, (Object)connectorClassOrAlias);
        return classLoader;
    }

    private static PluginClassLoader newPluginClassLoader(URL pluginLocation, URL[] urls, ClassLoader parent) {
        return AccessController.doPrivileged(() -> new PluginClassLoader(pluginLocation, urls, parent));
    }

    private <T> void addPlugins(Collection<PluginDesc<T>> plugins, ClassLoader loader) {
        for (PluginDesc<T> plugin : plugins) {
            String pluginClassName = plugin.className();
            SortedMap<PluginDesc<?>, ClassLoader> inner = this.pluginLoaders.get(pluginClassName);
            if (inner == null) {
                inner = new TreeMap();
                this.pluginLoaders.put(pluginClassName, inner);
                log.info("Added plugin '{}'", (Object)pluginClassName);
            }
            inner.put(plugin, loader);
        }
    }

    protected void initLoaders() {
        for (String configPath : this.pluginPaths) {
            this.initPluginLoader(configPath);
        }
        this.initPluginLoader(CLASSPATH_NAME);
        this.addAllAliases();
    }

    private void initPluginLoader(String path) {
        try {
            if (CLASSPATH_NAME.equals(path)) {
                this.scanUrlsAndAddPlugins(this.getParent(), ClasspathHelper.forJavaClassPath().toArray(new URL[0]), null);
            } else {
                Path pluginPath = Paths.get(path, new String[0]).toAbsolutePath();
                path = pluginPath.toString();
                if (Files.isDirectory(pluginPath, new LinkOption[0])) {
                    for (Path pluginLocation : PluginUtils.pluginLocations(pluginPath)) {
                        this.registerPlugin(pluginLocation);
                    }
                } else if (PluginUtils.isArchive(pluginPath)) {
                    this.registerPlugin(pluginPath);
                }
            }
        }
        catch (MalformedURLException | InvalidPathException e) {
            log.error("Invalid path in plugin path: {}. Ignoring.", (Object)path, (Object)e);
        }
        catch (IOException e) {
            log.error("Could not get listing for plugin path: {}. Ignoring.", (Object)path, (Object)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Could not instantiate plugins in: {}. Ignoring: {}", (Object)path, (Object)e);
        }
    }

    private void registerPlugin(Path pluginLocation) throws InstantiationException, IllegalAccessException, IOException {
        log.info("Loading plugin from: {}", (Object)pluginLocation);
        ArrayList<URL> pluginUrls = new ArrayList<URL>();
        for (Path path : PluginUtils.pluginUrls(pluginLocation)) {
            pluginUrls.add(path.toUri().toURL());
        }
        Object[] urls = pluginUrls.toArray(new URL[0]);
        if (log.isDebugEnabled()) {
            log.debug("Loading plugin urls: {}", (Object)Arrays.toString(urls));
        }
        PluginClassLoader loader = DelegatingClassLoader.newPluginClassLoader(pluginLocation.toUri().toURL(), (URL[])urls, this);
        this.scanUrlsAndAddPlugins(loader, (URL[])urls, pluginLocation);
    }

    private void scanUrlsAndAddPlugins(ClassLoader loader, URL[] urls, Path pluginLocation) throws InstantiationException, IllegalAccessException {
        PluginScanResult plugins = this.scanPluginPath(loader, urls);
        log.info("Registered loader: {}", (Object)loader);
        if (!plugins.isEmpty()) {
            this.addPlugins(plugins.connectors(), loader);
            this.connectors.addAll(plugins.connectors());
            this.addPlugins(plugins.converters(), loader);
            this.converters.addAll(plugins.converters());
            this.addPlugins(plugins.headerConverters(), loader);
            this.headerConverters.addAll(plugins.headerConverters());
            this.addPlugins(plugins.transformations(), loader);
            this.transformations.addAll(plugins.transformations());
            this.addPlugins(plugins.predicates(), loader);
            this.predicates.addAll(plugins.predicates());
            this.addPlugins(plugins.configProviders(), loader);
            this.configProviders.addAll(plugins.configProviders());
            this.addPlugins(plugins.restExtensions(), loader);
            this.restExtensions.addAll(plugins.restExtensions());
            this.addPlugins(plugins.connectorClientConfigPolicies(), loader);
            this.connectorClientConfigPolicies.addAll(plugins.connectorClientConfigPolicies());
        }
        this.loadJdbcDrivers(loader);
    }

    private void loadJdbcDrivers(ClassLoader loader) {
        AccessController.doPrivileged(() -> {
            ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class, loader);
            Iterator<Driver> driversIterator = loadedDrivers.iterator();
            try {
                while (driversIterator.hasNext()) {
                    Driver driver = driversIterator.next();
                    log.debug("Registered java.sql.Driver: {} to java.sql.DriverManager", (Object)driver);
                }
            }
            catch (Throwable t) {
                log.debug("Ignoring java.sql.Driver classes listed in resources but not present in class loader's classpath: ", t);
            }
            return null;
        });
    }

    private PluginScanResult scanPluginPath(ClassLoader loader, URL[] urls) throws InstantiationException, IllegalAccessException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setClassLoaders(new ClassLoader[]{loader});
        builder.addUrls(urls);
        builder.setScanners(new Scanner[]{new SubTypesScanner()});
        builder.useParallelExecutor();
        InternalReflections reflections = new InternalReflections((Configuration)builder);
        return new PluginScanResult(this.getPluginDesc(reflections, Connector.class, loader), this.getPluginDesc(reflections, Converter.class, loader), this.getPluginDesc(reflections, HeaderConverter.class, loader), this.getPluginDesc(reflections, Transformation.class, loader), this.getPluginDesc(reflections, Predicate.class, loader), this.getServiceLoaderPluginDesc(ConfigProvider.class, loader), this.getServiceLoaderPluginDesc(ConnectRestExtension.class, loader), this.getServiceLoaderPluginDesc(ConnectorClientConfigOverridePolicy.class, loader));
    }

    private <T> Collection<PluginDesc<T>> getPluginDesc(Reflections reflections, Class<T> klass, ClassLoader loader) throws InstantiationException, IllegalAccessException {
        Set plugins;
        try {
            plugins = reflections.getSubTypesOf(klass);
        }
        catch (ReflectionsException e) {
            log.debug("Reflections scanner could not find any classes for URLs: " + reflections.getConfiguration().getUrls(), (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<PluginDesc<T>> result = new ArrayList<PluginDesc<T>>();
        for (Class plugin : plugins) {
            if (PluginUtils.isConcrete(plugin)) {
                result.add(new PluginDesc(plugin, DelegatingClassLoader.versionFor(plugin), loader));
                continue;
            }
            log.debug("Skipping {} as it is not concrete implementation", (Object)plugin);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Collection<PluginDesc<T>> getServiceLoaderPluginDesc(Class<T> klass, ClassLoader loader) {
        ClassLoader savedLoader = Plugins.compareAndSwapLoaders(loader);
        ArrayList<PluginDesc<T>> result = new ArrayList<PluginDesc<T>>();
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(klass, loader);
            for (T pluginImpl : serviceLoader) {
                result.add(new PluginDesc(pluginImpl.getClass(), DelegatingClassLoader.versionFor(pluginImpl), loader));
            }
        }
        finally {
            Plugins.compareAndSwapLoaders(savedLoader);
        }
        return result;
    }

    private static <T> String versionFor(T pluginImpl) {
        return pluginImpl instanceof Versioned ? ((Versioned)pluginImpl).version() : UNDEFINED_VERSION;
    }

    private static <T> String versionFor(Class<? extends T> pluginKlass) throws IllegalAccessException, InstantiationException {
        return Connector.class.isAssignableFrom(pluginKlass) ? DelegatingClassLoader.versionFor(pluginKlass.newInstance()) : UNDEFINED_VERSION;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String fullName = this.aliases.containsKey(name) ? this.aliases.get(name) : name;
        PluginClassLoader pluginLoader = this.pluginClassLoader(fullName);
        if (pluginLoader != null) {
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)fullName, (Object)pluginLoader);
            return pluginLoader.loadClass(fullName, resolve);
        }
        return super.loadClass(fullName, resolve);
    }

    private void addAllAliases() {
        this.addAliases(this.connectors);
        this.addAliases(this.converters);
        this.addAliases(this.headerConverters);
        this.addAliases(this.transformations);
        this.addAliases(this.predicates);
        this.addAliases(this.restExtensions);
        this.addAliases(this.connectorClientConfigPolicies);
    }

    private <S> void addAliases(Collection<PluginDesc<S>> plugins) {
        for (PluginDesc pluginDesc : plugins) {
            if (!PluginUtils.isAliasUnique(pluginDesc, plugins)) continue;
            String simple = PluginUtils.simpleName(pluginDesc);
            String pruned = PluginUtils.prunedName(pluginDesc);
            this.aliases.put(simple, pluginDesc.className());
            if (simple.equals(pruned)) {
                log.info("Added alias '{}' to plugin '{}'", (Object)simple, (Object)pluginDesc.className());
                continue;
            }
            this.aliases.put(pruned, pluginDesc.className());
            log.info("Added aliases '{}' and '{}' to plugin '{}'", new Object[]{simple, pruned, pluginDesc.className()});
        }
    }

    @Override
    public URL getResource(String name) {
        if (DelegatingClassLoader.serviceLoaderManifestForPlugin(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (DelegatingClassLoader.serviceLoaderManifestForPlugin(name)) {
            return null;
        }
        return super.getResources(name);
    }

    static boolean serviceLoaderManifestForPlugin(String name) {
        return PLUGIN_MANIFEST_FILES.contains(name);
    }

    private static class InternalReflections
    extends Reflections {
        public InternalReflections(Configuration configuration) {
            super(configuration);
        }

        protected void scan(URL url) {
            block2: {
                try {
                    super.scan(url);
                }
                catch (ReflectionsException e) {
                    Logger log = Reflections.log;
                    if (log == null || !log.isWarnEnabled()) break block2;
                    log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
                }
            }
        }
    }
}

