/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Time;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.ConnectAssignor;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.ConnectProtocol;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.ExtendedAssignment;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.ExtendedWorkerState;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.IncrementalCooperativeConnectProtocol;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.distributed.WorkerCoordinator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;

public class IncrementalCooperativeAssignor
implements ConnectAssignor {
    private final Logger log;
    private final Time time;
    private final int maxDelay;
    private WorkerCoordinator.ConnectorsAndTasks previousAssignment;
    private WorkerCoordinator.ConnectorsAndTasks previousRevocation;
    private boolean canRevoke;
    protected final Set<String> candidateWorkersForReassignment;
    protected long scheduledRebalance;
    protected int delay;
    protected int previousGenerationId;
    protected Set<String> previousMembers;

    public IncrementalCooperativeAssignor(LogContext logContext, Time time, int maxDelay) {
        this.log = logContext.logger(IncrementalCooperativeAssignor.class);
        this.time = time;
        this.maxDelay = maxDelay;
        this.previousAssignment = WorkerCoordinator.ConnectorsAndTasks.EMPTY;
        this.previousRevocation = new WorkerCoordinator.ConnectorsAndTasks.Builder().build();
        this.canRevoke = true;
        this.scheduledRebalance = 0L;
        this.candidateWorkersForReassignment = new LinkedHashSet<String>();
        this.delay = 0;
        this.previousGenerationId = -1;
        this.previousMembers = Collections.emptySet();
    }

    @Override
    public Map<String, ByteBuffer> performAssignment(String leaderId, String protocol, List<JoinGroupResponseData.JoinGroupResponseMember> allMemberMetadata, WorkerCoordinator coordinator) {
        this.log.debug("Performing task assignment");
        HashMap<String, ExtendedWorkerState> memberConfigs = new HashMap<String, ExtendedWorkerState>();
        for (JoinGroupResponseData.JoinGroupResponseMember member : allMemberMetadata) {
            memberConfigs.put(member.memberId(), IncrementalCooperativeConnectProtocol.deserializeMetadata(ByteBuffer.wrap(member.metadata())));
        }
        this.log.debug("Member configs: {}", memberConfigs);
        long maxOffset = memberConfigs.values().stream().map(ConnectProtocol.WorkerState::offset).max(Long::compare).get();
        this.log.debug("Max config offset root: {}, local snapshot config offsets root: {}", (Object)maxOffset, (Object)coordinator.configSnapshot().offset());
        short protocolVersion = memberConfigs.values().stream().allMatch(state -> state.assignment().version() == 2) ? (short)2 : 1;
        Long leaderOffset = this.ensureLeaderConfig(maxOffset, coordinator);
        if (leaderOffset == null) {
            Map<String, ExtendedAssignment> assignments = this.fillAssignments(memberConfigs.keySet(), (short)1, leaderId, ((ExtendedWorkerState)memberConfigs.get(leaderId)).url(), maxOffset, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0, protocolVersion);
            return this.serializeAssignments(assignments);
        }
        return this.performTaskAssignment(leaderId, leaderOffset, memberConfigs, coordinator, protocolVersion);
    }

    private Long ensureLeaderConfig(long maxOffset, WorkerCoordinator coordinator) {
        if (coordinator.configSnapshot().offset() < maxOffset) {
            ClusterConfigState updatedSnapshot = coordinator.configFreshSnapshot();
            if (updatedSnapshot.offset() < maxOffset) {
                this.log.info("Was selected to perform assignments, but do not have latest config found in sync request. Returning an empty configuration to trigger re-sync.");
                return null;
            }
            coordinator.configSnapshot(updatedSnapshot);
            return updatedSnapshot.offset();
        }
        return maxOffset;
    }

    protected Map<String, ByteBuffer> performTaskAssignment(String leaderId, long maxOffset, Map<String, ExtendedWorkerState> memberConfigs, WorkerCoordinator coordinator, short protocolVersion) {
        this.log.debug("Performing task assignment during generation: {} with memberId: {}", (Object)coordinator.generationId(), (Object)coordinator.memberId());
        this.log.debug("Previous assignments: {}", (Object)this.previousAssignment);
        int lastCompletedGenerationId = coordinator.lastCompletedGenerationId();
        if (this.previousGenerationId != lastCompletedGenerationId) {
            this.log.debug("Clearing the view of previous assignments due to generation mismatch between previous generation ID {} and last completed generation ID {}. This can happen if the leader fails to sync the assignment within a rebalancing round. The following view of previous assignments might be outdated and will be ignored by the leader in the current computation of new assignments. Possibly outdated previous assignments: {}", new Object[]{this.previousGenerationId, lastCompletedGenerationId, this.previousAssignment});
            this.previousAssignment = WorkerCoordinator.ConnectorsAndTasks.EMPTY;
        }
        ClusterConfigState snapshot = coordinator.configSnapshot();
        TreeSet<String> configuredConnectors = new TreeSet<String>(snapshot.connectors());
        Set<ConnectorTaskId> configuredTasks = configuredConnectors.stream().flatMap(c -> snapshot.tasks((String)c).stream()).collect(Collectors.toSet());
        WorkerCoordinator.ConnectorsAndTasks configured = new WorkerCoordinator.ConnectorsAndTasks.Builder().with(configuredConnectors, configuredTasks).build();
        this.log.debug("Configured assignments: {}", (Object)configured);
        WorkerCoordinator.ConnectorsAndTasks activeAssignments = this.assignment(memberConfigs);
        this.log.debug("Active assignments: {}", (Object)activeAssignments);
        if (!this.previousRevocation.isEmpty()) {
            if (this.previousRevocation.connectors().stream().anyMatch(c -> activeAssignments.connectors().contains(c)) || this.previousRevocation.tasks().stream().anyMatch(t -> activeAssignments.tasks().contains(t))) {
                this.previousAssignment = activeAssignments;
                this.canRevoke = true;
            }
            this.previousRevocation.connectors().clear();
            this.previousRevocation.tasks().clear();
        }
        WorkerCoordinator.ConnectorsAndTasks deleted = IncrementalCooperativeAssignor.diff(this.previousAssignment, configured);
        this.log.debug("Deleted assignments: {}", (Object)deleted);
        WorkerCoordinator.ConnectorsAndTasks remainingActive = IncrementalCooperativeAssignor.diff(activeAssignments, deleted);
        this.log.debug("Remaining (excluding deleted) active assignments: {}", (Object)remainingActive);
        WorkerCoordinator.ConnectorsAndTasks lostAssignments = IncrementalCooperativeAssignor.diff(this.previousAssignment, activeAssignments, deleted);
        this.log.debug("Lost assignments: {}", (Object)lostAssignments);
        WorkerCoordinator.ConnectorsAndTasks newSubmissions = IncrementalCooperativeAssignor.diff(configured, this.previousAssignment, activeAssignments);
        this.log.debug("New assignments: {}", (Object)newSubmissions);
        List<WorkerCoordinator.WorkerLoad> completeWorkerAssignment = IncrementalCooperativeAssignor.workerAssignment(memberConfigs, WorkerCoordinator.ConnectorsAndTasks.EMPTY);
        this.log.debug("Complete (ignoring deletions) worker assignments: {}", completeWorkerAssignment);
        Map<String, Collection<String>> connectorAssignments = completeWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::connectors));
        this.log.debug("Complete (ignoring deletions) connector assignments: {}", connectorAssignments);
        Map<String, Collection<ConnectorTaskId>> taskAssignments = completeWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::tasks));
        this.log.debug("Complete (ignoring deletions) task assignments: {}", taskAssignments);
        List<WorkerCoordinator.WorkerLoad> currentWorkerAssignment = IncrementalCooperativeAssignor.workerAssignment(memberConfigs, deleted);
        Map<String, WorkerCoordinator.ConnectorsAndTasks> toRevoke = this.computeDeleted(deleted, connectorAssignments, taskAssignments);
        this.log.debug("Connector and task to delete assignments: {}", toRevoke);
        toRevoke.putAll(this.computeDuplicatedAssignments(memberConfigs, connectorAssignments, taskAssignments));
        this.log.debug("Connector and task to revoke assignments (include duplicated assignments): {}", toRevoke);
        completeWorkerAssignment = IncrementalCooperativeAssignor.workerAssignment(memberConfigs, deleted);
        connectorAssignments = completeWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::connectors));
        taskAssignments = completeWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::tasks));
        this.handleLostAssignments(lostAssignments, newSubmissions, completeWorkerAssignment, memberConfigs);
        this.canRevoke = this.delay == 0 && this.canRevoke;
        this.log.debug("Can leader revoke tasks in this assignment? {} (delay: {})", (Object)this.canRevoke, (Object)this.delay);
        if (this.canRevoke) {
            Map<String, WorkerCoordinator.ConnectorsAndTasks> toExplicitlyRevoke = this.performTaskRevocation(activeAssignments, currentWorkerAssignment);
            this.log.debug("Connector and task to revoke assignments: {}", toRevoke);
            toExplicitlyRevoke.forEach((worker, assignment) -> {
                WorkerCoordinator.ConnectorsAndTasks existing = toRevoke.computeIfAbsent((String)worker, v -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build());
                existing.connectors().addAll(assignment.connectors());
                existing.tasks().addAll(assignment.tasks());
            });
            this.canRevoke = toExplicitlyRevoke.size() == 0;
        } else {
            this.canRevoke = this.delay == 0;
        }
        this.assignConnectors(completeWorkerAssignment, newSubmissions.connectors());
        this.assignTasks(completeWorkerAssignment, newSubmissions.tasks());
        this.log.debug("Current complete assignments: {}", currentWorkerAssignment);
        this.log.debug("New complete assignments: {}", completeWorkerAssignment);
        Map currentConnectorAssignments = currentWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::connectors));
        Map currentTaskAssignments = currentWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, WorkerCoordinator.WorkerLoad::tasks));
        Map<String, Collection<String>> incrementalConnectorAssignments = IncrementalCooperativeAssignor.diff(connectorAssignments, currentConnectorAssignments);
        Map<String, Collection<ConnectorTaskId>> incrementalTaskAssignments = IncrementalCooperativeAssignor.diff(taskAssignments, currentTaskAssignments);
        this.log.debug("Incremental connector assignments: {}", incrementalConnectorAssignments);
        this.log.debug("Incremental task assignments: {}", incrementalTaskAssignments);
        coordinator.leaderState(new WorkerCoordinator.LeaderState(memberConfigs, connectorAssignments, taskAssignments));
        Map<String, ExtendedAssignment> assignments = this.fillAssignments(memberConfigs.keySet(), (short)0, leaderId, memberConfigs.get(leaderId).url(), maxOffset, incrementalConnectorAssignments, incrementalTaskAssignments, toRevoke, this.delay, protocolVersion);
        this.previousAssignment = this.computePreviousAssignment(toRevoke, connectorAssignments, taskAssignments, lostAssignments);
        this.previousGenerationId = coordinator.generationId();
        this.previousMembers = memberConfigs.keySet();
        this.log.debug("Actual assignments: {}", assignments);
        return this.serializeAssignments(assignments);
    }

    private Map<String, WorkerCoordinator.ConnectorsAndTasks> computeDeleted(WorkerCoordinator.ConnectorsAndTasks deleted, Map<String, Collection<String>> connectorAssignments, Map<String, Collection<ConnectorTaskId>> taskAssignments) {
        Map<String, String> connectorOwners = WorkerCoordinator.invertAssignment(connectorAssignments);
        Map<ConnectorTaskId, String> taskOwners = WorkerCoordinator.invertAssignment(taskAssignments);
        HashMap<String, WorkerCoordinator.ConnectorsAndTasks> toRevoke = new HashMap<String, WorkerCoordinator.ConnectorsAndTasks>();
        deleted.connectors().forEach(c -> toRevoke.computeIfAbsent((String)connectorOwners.get(c), v -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build()).connectors().add((String)c));
        deleted.tasks().forEach(t -> toRevoke.computeIfAbsent((String)taskOwners.get(t), v -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build()).tasks().add((ConnectorTaskId)t));
        this.log.debug("Connectors and tasks to delete assignments: {}", toRevoke);
        return toRevoke;
    }

    private WorkerCoordinator.ConnectorsAndTasks computePreviousAssignment(Map<String, WorkerCoordinator.ConnectorsAndTasks> toRevoke, Map<String, Collection<String>> connectorAssignments, Map<String, Collection<ConnectorTaskId>> taskAssignments, WorkerCoordinator.ConnectorsAndTasks lostAssignments) {
        WorkerCoordinator.ConnectorsAndTasks previousAssignment = new WorkerCoordinator.ConnectorsAndTasks.Builder().with(connectorAssignments.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), taskAssignments.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())).build();
        for (WorkerCoordinator.ConnectorsAndTasks revoked : toRevoke.values()) {
            previousAssignment.connectors().removeAll(revoked.connectors());
            previousAssignment.tasks().removeAll(revoked.tasks());
            this.previousRevocation.connectors().addAll(revoked.connectors());
            this.previousRevocation.tasks().addAll(revoked.tasks());
        }
        previousAssignment.connectors().addAll(lostAssignments.connectors());
        previousAssignment.tasks().addAll(lostAssignments.tasks());
        return previousAssignment;
    }

    private WorkerCoordinator.ConnectorsAndTasks duplicatedAssignments(Map<String, ExtendedWorkerState> memberConfigs) {
        Set<String> connectors = memberConfigs.entrySet().stream().flatMap(memberConfig -> ((ExtendedWorkerState)memberConfig.getValue()).assignment().connectors().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<ConnectorTaskId> tasks = memberConfigs.values().stream().flatMap(state -> state.assignment().tasks().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        return new WorkerCoordinator.ConnectorsAndTasks.Builder().with(connectors, tasks).build();
    }

    private Map<String, WorkerCoordinator.ConnectorsAndTasks> computeDuplicatedAssignments(Map<String, ExtendedWorkerState> memberConfigs, Map<String, Collection<String>> connectorAssignments, Map<String, Collection<ConnectorTaskId>> taskAssignment) {
        WorkerCoordinator.ConnectorsAndTasks duplicatedAssignments = this.duplicatedAssignments(memberConfigs);
        this.log.debug("Duplicated assignments: {}", (Object)duplicatedAssignments);
        HashMap<String, WorkerCoordinator.ConnectorsAndTasks> toRevoke = new HashMap<String, WorkerCoordinator.ConnectorsAndTasks>();
        if (!duplicatedAssignments.connectors().isEmpty()) {
            connectorAssignments.entrySet().stream().forEach(entry -> {
                HashSet<String> duplicatedConnectors = new HashSet<String>(duplicatedAssignments.connectors());
                duplicatedConnectors.retainAll((Collection)entry.getValue());
                if (!duplicatedConnectors.isEmpty()) {
                    toRevoke.computeIfAbsent((String)entry.getKey(), v -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build()).connectors().addAll(duplicatedConnectors);
                }
            });
        }
        if (!duplicatedAssignments.tasks().isEmpty()) {
            taskAssignment.entrySet().stream().forEach(entry -> {
                HashSet<ConnectorTaskId> duplicatedTasks = new HashSet<ConnectorTaskId>(duplicatedAssignments.tasks());
                duplicatedTasks.retainAll((Collection)entry.getValue());
                if (!duplicatedTasks.isEmpty()) {
                    toRevoke.computeIfAbsent((String)entry.getKey(), v -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build()).tasks().addAll(duplicatedTasks);
                }
            });
        }
        return toRevoke;
    }

    protected void handleLostAssignments(WorkerCoordinator.ConnectorsAndTasks lostAssignments, WorkerCoordinator.ConnectorsAndTasks newSubmissions, List<WorkerCoordinator.WorkerLoad> completeWorkerAssignment, Map<String, ExtendedWorkerState> memberConfigs) {
        if (lostAssignments.isEmpty()) {
            this.resetDelay();
            return;
        }
        long now = this.time.milliseconds();
        this.log.debug("Found the following connectors and tasks missing from previous assignments: " + lostAssignments);
        if (this.scheduledRebalance <= 0L && memberConfigs.keySet().containsAll(this.previousMembers)) {
            this.log.debug("No worker seems to have departed the group during the rebalance. The missing assignments that the leader is detecting are probably due to some workers failing to receive the new assignments in the previous rebalance. Will reassign missing tasks as new tasks");
            newSubmissions.connectors().addAll(lostAssignments.connectors());
            newSubmissions.tasks().addAll(lostAssignments.tasks());
            return;
        }
        if (this.scheduledRebalance > 0L && now >= this.scheduledRebalance) {
            this.log.debug("Delayed rebalance expired. Reassigning lost tasks");
            List<Object> candidateWorkerLoad = Collections.emptyList();
            if (!this.candidateWorkersForReassignment.isEmpty()) {
                candidateWorkerLoad = this.pickCandidateWorkerForReassignment(completeWorkerAssignment);
            }
            if (!candidateWorkerLoad.isEmpty()) {
                WorkerCoordinator.WorkerLoad worker;
                this.log.debug("Assigning lost tasks to {} candidate workers: {}", (Object)candidateWorkerLoad.size(), (Object)candidateWorkerLoad.stream().map(WorkerCoordinator.WorkerLoad::worker).collect(Collectors.joining(",")));
                Iterator<Object> candidateWorkerIterator = candidateWorkerLoad.iterator();
                for (String connector : lostAssignments.connectors()) {
                    if (!candidateWorkerIterator.hasNext()) {
                        candidateWorkerIterator = candidateWorkerLoad.iterator();
                    }
                    worker = (WorkerCoordinator.WorkerLoad)candidateWorkerIterator.next();
                    this.log.debug("Assigning connector id {} to member {}", (Object)connector, (Object)worker.worker());
                    worker.assign(connector);
                }
                candidateWorkerIterator = candidateWorkerLoad.iterator();
                for (ConnectorTaskId task : lostAssignments.tasks()) {
                    if (!candidateWorkerIterator.hasNext()) {
                        candidateWorkerIterator = candidateWorkerLoad.iterator();
                    }
                    worker = (WorkerCoordinator.WorkerLoad)candidateWorkerIterator.next();
                    this.log.debug("Assigning task id {} to member {}", (Object)task, (Object)worker.worker());
                    worker.assign(task);
                }
            } else {
                this.log.debug("No single candidate worker was found to assign lost tasks. Treating lost tasks as new tasks");
                newSubmissions.connectors().addAll(lostAssignments.connectors());
                newSubmissions.tasks().addAll(lostAssignments.tasks());
            }
            this.resetDelay();
        } else {
            this.candidateWorkersForReassignment.addAll(this.candidateWorkersForReassignment(completeWorkerAssignment));
            if (now < this.scheduledRebalance) {
                this.delay = this.calculateDelay(now);
                this.log.debug("Delayed rebalance in progress. Task reassignment is postponed. New computed rebalance delay: {}", (Object)this.delay);
            } else {
                this.delay = this.maxDelay;
                this.log.debug("Resetting rebalance delay to the max: {}. scheduledRebalance: {} now: {} diff scheduledRebalance - now: {}", new Object[]{this.delay, this.scheduledRebalance, now, this.scheduledRebalance - now});
            }
            this.scheduledRebalance = now + (long)this.delay;
        }
    }

    private void resetDelay() {
        this.candidateWorkersForReassignment.clear();
        this.scheduledRebalance = 0L;
        if (this.delay != 0) {
            this.log.debug("Resetting delay from previous value: {} to 0", (Object)this.delay);
        }
        this.delay = 0;
    }

    private Set<String> candidateWorkersForReassignment(List<WorkerCoordinator.WorkerLoad> completeWorkerAssignment) {
        return completeWorkerAssignment.stream().filter(WorkerCoordinator.WorkerLoad::isEmpty).map(WorkerCoordinator.WorkerLoad::worker).collect(Collectors.toSet());
    }

    private List<WorkerCoordinator.WorkerLoad> pickCandidateWorkerForReassignment(List<WorkerCoordinator.WorkerLoad> completeWorkerAssignment) {
        Map activeWorkers = completeWorkerAssignment.stream().collect(Collectors.toMap(WorkerCoordinator.WorkerLoad::worker, Function.identity()));
        return this.candidateWorkersForReassignment.stream().map(activeWorkers::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, WorkerCoordinator.ConnectorsAndTasks> performTaskRevocation(WorkerCoordinator.ConnectorsAndTasks activeAssignments, Collection<WorkerCoordinator.WorkerLoad> completeWorkerAssignment) {
        WorkerCoordinator.ConnectorsAndTasks resources;
        int i;
        int numToRevoke;
        int totalActiveConnectorsNum = activeAssignments.connectors().size();
        int totalActiveTasksNum = activeAssignments.tasks().size();
        Collection existingWorkers = completeWorkerAssignment.stream().filter(wl -> wl.size() > 0).collect(Collectors.toList());
        int existingWorkersNum = existingWorkers.size();
        int totalWorkersNum = completeWorkerAssignment.size();
        int newWorkersNum = totalWorkersNum - existingWorkersNum;
        if (this.log.isDebugEnabled()) {
            completeWorkerAssignment.forEach(wl -> this.log.debug("Per worker current load size; worker: {} connectors: {} tasks: {}", new Object[]{wl.worker(), wl.connectorsSize(), wl.tasksSize()}));
        }
        HashMap<String, WorkerCoordinator.ConnectorsAndTasks> revoking = new HashMap<String, WorkerCoordinator.ConnectorsAndTasks>();
        if (newWorkersNum <= 0 || existingWorkersNum <= 0) {
            this.log.debug("No task revocation required; workers with existing load: {} workers with no load {} total workers {}", new Object[]{existingWorkersNum, newWorkersNum, totalWorkersNum});
            return revoking;
        }
        this.log.debug("Task revocation is required; workers with existing load: {} workers with no load {} total workers {}", new Object[]{existingWorkersNum, newWorkersNum, totalWorkersNum});
        this.log.debug("Previous rounded down (floor) average number of connectors per worker {}", (Object)(totalActiveConnectorsNum / existingWorkersNum));
        int floorConnectors = totalActiveConnectorsNum / totalWorkersNum;
        int ceilConnectors = floorConnectors + (totalActiveConnectorsNum % totalWorkersNum == 0 ? 0 : 1);
        this.log.debug("New average number of connectors per worker rounded down (floor) {} and rounded up (ceil) {}", (Object)floorConnectors, (Object)ceilConnectors);
        this.log.debug("Previous rounded down (floor) average number of tasks per worker {}", (Object)(totalActiveTasksNum / existingWorkersNum));
        int floorTasks = totalActiveTasksNum / totalWorkersNum;
        int ceilTasks = floorTasks + (totalActiveTasksNum % totalWorkersNum == 0 ? 0 : 1);
        this.log.debug("New average number of tasks per worker rounded down (floor) {} and rounded up (ceil) {}", (Object)floorTasks, (Object)ceilTasks);
        for (WorkerCoordinator.WorkerLoad existing : existingWorkers) {
            Iterator<String> connectors = existing.connectors().iterator();
            numToRevoke = existing.connectorsSize() - ceilConnectors;
            for (i = existing.connectorsSize(); i > floorConnectors && numToRevoke > 0; --i, --numToRevoke) {
                resources = revoking.computeIfAbsent(existing.worker(), w -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build());
                resources.connectors().add(connectors.next());
            }
        }
        for (WorkerCoordinator.WorkerLoad existing : existingWorkers) {
            Iterator<ConnectorTaskId> tasks = existing.tasks().iterator();
            numToRevoke = existing.tasksSize() - ceilTasks;
            this.log.debug("Tasks on worker {} is higher than ceiling, so revoking {} tasks", (Object)existing, (Object)numToRevoke);
            for (i = existing.tasksSize(); i > floorTasks && numToRevoke > 0; --i, --numToRevoke) {
                resources = revoking.computeIfAbsent(existing.worker(), w -> new WorkerCoordinator.ConnectorsAndTasks.Builder().build());
                resources.tasks().add(tasks.next());
            }
        }
        return revoking;
    }

    private Map<String, ExtendedAssignment> fillAssignments(Collection<String> members, short error, String leaderId, String leaderUrl, long maxOffset, Map<String, Collection<String>> connectorAssignments, Map<String, Collection<ConnectorTaskId>> taskAssignments, Map<String, WorkerCoordinator.ConnectorsAndTasks> revoked, int delay, short protocolVersion) {
        HashMap<String, ExtendedAssignment> groupAssignment = new HashMap<String, ExtendedAssignment>();
        for (String member : members) {
            Collection connectorsToStart = connectorAssignments.getOrDefault(member, Collections.emptyList());
            Collection tasksToStart = taskAssignments.getOrDefault(member, Collections.emptyList());
            Collection<String> connectorsToStop = revoked.getOrDefault(member, WorkerCoordinator.ConnectorsAndTasks.EMPTY).connectors();
            Collection<ConnectorTaskId> tasksToStop = revoked.getOrDefault(member, WorkerCoordinator.ConnectorsAndTasks.EMPTY).tasks();
            ExtendedAssignment assignment = new ExtendedAssignment(protocolVersion, error, leaderId, leaderUrl, maxOffset, connectorsToStart, tasksToStart, connectorsToStop, tasksToStop, delay);
            this.log.debug("Filling assignment: {} -> {}", (Object)member, (Object)assignment);
            groupAssignment.put(member, assignment);
        }
        this.log.debug("Finished assignment");
        return groupAssignment;
    }

    protected Map<String, ByteBuffer> serializeAssignments(Map<String, ExtendedAssignment> assignments) {
        return assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> IncrementalCooperativeConnectProtocol.serializeAssignment((ExtendedAssignment)e.getValue())));
    }

    private static WorkerCoordinator.ConnectorsAndTasks diff(WorkerCoordinator.ConnectorsAndTasks base, WorkerCoordinator.ConnectorsAndTasks ... toSubtract) {
        TreeSet<String> connectors = new TreeSet<String>(base.connectors());
        TreeSet<ConnectorTaskId> tasks = new TreeSet<ConnectorTaskId>(base.tasks());
        for (WorkerCoordinator.ConnectorsAndTasks sub : toSubtract) {
            connectors.removeAll(sub.connectors());
            tasks.removeAll(sub.tasks());
        }
        return new WorkerCoordinator.ConnectorsAndTasks.Builder().with(connectors, tasks).build();
    }

    private static <T> Map<String, Collection<T>> diff(Map<String, Collection<T>> base, Map<String, Collection<T>> toSubtract) {
        HashMap<String, Collection<T>> incremental = new HashMap<String, Collection<T>>();
        for (Map.Entry<String, Collection<T>> entry : base.entrySet()) {
            ArrayList<T> values = new ArrayList<T>(entry.getValue());
            values.removeAll(toSubtract.get(entry.getKey()));
            incremental.put(entry.getKey(), values);
        }
        return incremental;
    }

    private WorkerCoordinator.ConnectorsAndTasks assignment(Map<String, ExtendedWorkerState> memberConfigs) {
        this.log.debug("Received assignments: {}", memberConfigs);
        Set<String> connectors = memberConfigs.values().stream().flatMap(state -> state.assignment().connectors().stream()).collect(Collectors.toSet());
        Set<ConnectorTaskId> tasks = memberConfigs.values().stream().flatMap(state -> state.assignment().tasks().stream()).collect(Collectors.toSet());
        return new WorkerCoordinator.ConnectorsAndTasks.Builder().with(connectors, tasks).build();
    }

    private int calculateDelay(long now) {
        long diff = this.scheduledRebalance - now;
        return diff > 0L ? (int)Math.min(diff, (long)this.maxDelay) : 0;
    }

    protected void assignConnectors(List<WorkerCoordinator.WorkerLoad> workerAssignment, Collection<String> connectors) {
        workerAssignment.sort(WorkerCoordinator.WorkerLoad.connectorComparator());
        WorkerCoordinator.WorkerLoad first = workerAssignment.get(0);
        Iterator<String> load = connectors.iterator();
        block0: while (load.hasNext()) {
            int firstLoad = first.connectorsSize();
            int upTo = IntStream.range(0, workerAssignment.size()).filter(i -> ((WorkerCoordinator.WorkerLoad)workerAssignment.get(i)).connectorsSize() > firstLoad).findFirst().orElse(workerAssignment.size());
            for (WorkerCoordinator.WorkerLoad worker : workerAssignment.subList(0, upTo)) {
                String connector = load.next();
                this.log.debug("Assigning connector {} to {}", (Object)connector, (Object)worker.worker());
                worker.assign(connector);
                if (load.hasNext()) continue;
                continue block0;
            }
        }
    }

    protected void assignTasks(List<WorkerCoordinator.WorkerLoad> workerAssignment, Collection<ConnectorTaskId> tasks) {
        workerAssignment.sort(WorkerCoordinator.WorkerLoad.taskComparator());
        WorkerCoordinator.WorkerLoad first = workerAssignment.get(0);
        Iterator<ConnectorTaskId> load = tasks.iterator();
        block0: while (load.hasNext()) {
            int firstLoad = first.tasksSize();
            int upTo = IntStream.range(0, workerAssignment.size()).filter(i -> ((WorkerCoordinator.WorkerLoad)workerAssignment.get(i)).tasksSize() > firstLoad).findFirst().orElse(workerAssignment.size());
            for (WorkerCoordinator.WorkerLoad worker : workerAssignment.subList(0, upTo)) {
                ConnectorTaskId task = load.next();
                this.log.debug("Assigning task {} to {}", (Object)task, (Object)worker.worker());
                worker.assign(task);
                if (load.hasNext()) continue;
                continue block0;
            }
        }
    }

    private static List<WorkerCoordinator.WorkerLoad> workerAssignment(Map<String, ExtendedWorkerState> memberConfigs, WorkerCoordinator.ConnectorsAndTasks toExclude) {
        WorkerCoordinator.ConnectorsAndTasks ignore = new WorkerCoordinator.ConnectorsAndTasks.Builder().with(new HashSet<String>(toExclude.connectors()), new HashSet<ConnectorTaskId>(toExclude.tasks())).build();
        return memberConfigs.entrySet().stream().map(e -> new WorkerCoordinator.WorkerLoad.Builder((String)e.getKey()).with(((ExtendedWorkerState)e.getValue()).assignment().connectors().stream().filter(v -> !ignore.connectors().contains(v)).collect(Collectors.toList()), ((ExtendedWorkerState)e.getValue()).assignment().tasks().stream().filter(v -> !ignore.tasks().contains(v)).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }
}

