/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime.errors.Stage;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationChain<R extends ConnectRecord<R>>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TransformationChain.class);
    private final List<Transformation<R>> transformations;
    private final RetryWithToleranceOperator retryWithToleranceOperator;

    public TransformationChain(List<Transformation<R>> transformations, RetryWithToleranceOperator retryWithToleranceOperator) {
        this.transformations = transformations;
        this.retryWithToleranceOperator = retryWithToleranceOperator;
    }

    public R apply(R record) {
        if (this.transformations.isEmpty()) {
            return record;
        }
        for (Transformation transformation : this.transformations) {
            Object current = record;
            log.trace("Applying transformation {} to {}", (Object)transformation.getClass().getName(), record);
            record = (ConnectRecord)this.retryWithToleranceOperator.execute(() -> transformation.apply(current), Stage.TRANSFORMATION, transformation.getClass());
            if (record != null) continue;
            break;
        }
        return record;
    }

    @Override
    public void close() {
        for (Transformation<R> transformation : this.transformations) {
            transformation.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationChain that = (TransformationChain)o;
        return Objects.equals(this.transformations, that.transformations);
    }

    public int hashCode() {
        return Objects.hash(this.transformations);
    }

    public String toString() {
        StringJoiner chain = new StringJoiner(", ", this.getClass().getName() + "{", "}");
        for (Transformation<R> transformation : this.transformations) {
            chain.add(transformation.getClass().getName());
        }
        return chain.toString();
    }
}

