/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.runtime;

import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.util.ConnectorTaskId;

public class TopicStatus {
    private final String topic;
    private final String connector;
    private final int task;
    private final long discoverTimestamp;

    public TopicStatus(String topic, ConnectorTaskId task, long discoverTimestamp) {
        this(topic, task.connector(), task.task(), discoverTimestamp);
    }

    public TopicStatus(String topic, String connector, int task, long discoverTimestamp) {
        this.topic = Objects.requireNonNull(topic);
        this.connector = Objects.requireNonNull(connector);
        this.task = task;
        this.discoverTimestamp = discoverTimestamp;
    }

    public String topic() {
        return this.topic;
    }

    public String connector() {
        return this.connector;
    }

    public int task() {
        return this.task;
    }

    public long discoverTimestamp() {
        return this.discoverTimestamp;
    }

    public String toString() {
        return "TopicStatus{topic='" + this.topic + '\'' + ", connector='" + this.connector + '\'' + ", task=" + this.task + ", discoverTimestamp=" + this.discoverTimestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicStatus)) {
            return false;
        }
        TopicStatus that = (TopicStatus)o;
        return this.task == that.task && this.discoverTimestamp == that.discoverTimestamp && this.topic.equals(that.topic) && this.connector.equals(that.connector);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.connector, this.task, this.discoverTimestamp);
    }
}

