/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.DataException;

public class Date {
    public static final String LOGICAL_NAME = "org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Date";
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final Schema SCHEMA = Date.builder().schema();

    public static SchemaBuilder builder() {
        return SchemaBuilder.int32().name(LOGICAL_NAME).version(1);
    }

    public static int fromLogical(Schema schema, java.util.Date value) {
        if (!LOGICAL_NAME.equals(schema.name())) {
            throw new DataException("Requested conversion of Date object but the schema does not match.");
        }
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTime(value);
        if (calendar.get(11) != 0 || calendar.get(12) != 0 || calendar.get(13) != 0 || calendar.get(14) != 0) {
            throw new DataException("Kafka Connect Date type should not have any time fields set to non-zero values.");
        }
        long unixMillis = calendar.getTimeInMillis();
        return (int)(unixMillis / 86400000L);
    }

    public static java.util.Date toLogical(Schema schema, int value) {
        if (!LOGICAL_NAME.equals(schema.name())) {
            throw new DataException("Requested conversion of Date object but the schema does not match.");
        }
        return new java.util.Date((long)value * 86400000L);
    }
}

