/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.serialization.Serializer;

public class UUIDSerializer
implements Serializer<UUID> {
    private String encoding = "UTF8";

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.serializer.encoding" : "value.serializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("serializer.encoding");
        }
        if (encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    @Override
    public byte[] serialize(String topic, UUID data) {
        try {
            if (data == null) {
                return null;
            }
            return data.toString().getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when serializing UUID to byte[] due to unsupported encoding " + this.encoding);
        }
    }
}

