/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.security.scram.internals;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.KafkaException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.security.scram.internals.ScramMessages;

public class ScramFormatter {
    private static final Pattern EQUAL = Pattern.compile("=", 16);
    private static final Pattern COMMA = Pattern.compile(",", 16);
    private static final Pattern EQUAL_TWO_C = Pattern.compile("=2C", 16);
    private static final Pattern EQUAL_THREE_D = Pattern.compile("=3D", 16);
    private final MessageDigest messageDigest;
    private final Mac mac;
    private final SecureRandom random;

    public ScramFormatter(ScramMechanism mechanism) throws NoSuchAlgorithmException {
        this.messageDigest = MessageDigest.getInstance(mechanism.hashAlgorithm());
        this.mac = Mac.getInstance(mechanism.macAlgorithm());
        this.random = new SecureRandom();
    }

    public byte[] hmac(byte[] key, byte[] bytes) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(key, this.mac.getAlgorithm()));
        return this.mac.doFinal(bytes);
    }

    public byte[] hash(byte[] str) {
        return this.messageDigest.digest(str);
    }

    public static byte[] xor(byte[] first, byte[] second) {
        if (first.length != second.length) {
            throw new IllegalArgumentException("Argument arrays must be of the same length");
        }
        byte[] result = new byte[first.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(first[i] ^ second[i]);
        }
        return result;
    }

    public byte[] hi(byte[] str, byte[] salt, int iterations) throws InvalidKeyException {
        byte[] u1;
        this.mac.init(new SecretKeySpec(str, this.mac.getAlgorithm()));
        this.mac.update(salt);
        byte[] prev = u1 = this.mac.doFinal(new byte[]{0, 0, 0, 1});
        byte[] result = u1;
        for (int i = 2; i <= iterations; ++i) {
            byte[] ui = this.hmac(str, prev);
            result = ScramFormatter.xor(result, ui);
            prev = ui;
        }
        return result;
    }

    public static byte[] normalize(String str) {
        return ScramFormatter.toBytes(str);
    }

    public byte[] saltedPassword(String password, byte[] salt, int iterations) throws InvalidKeyException {
        return this.hi(ScramFormatter.normalize(password), salt, iterations);
    }

    public byte[] clientKey(byte[] saltedPassword) throws InvalidKeyException {
        return this.hmac(saltedPassword, ScramFormatter.toBytes("Client Key"));
    }

    public byte[] storedKey(byte[] clientKey) {
        return this.hash(clientKey);
    }

    public static String saslName(String username) {
        String replace1 = EQUAL.matcher(username).replaceAll(Matcher.quoteReplacement("=3D"));
        return COMMA.matcher(replace1).replaceAll(Matcher.quoteReplacement("=2C"));
    }

    public static String username(String saslName) {
        String username = EQUAL_TWO_C.matcher(saslName).replaceAll(Matcher.quoteReplacement(","));
        if (EQUAL_THREE_D.matcher(username).replaceAll(Matcher.quoteReplacement("")).indexOf(61) >= 0) {
            throw new IllegalArgumentException("Invalid username: " + saslName);
        }
        return EQUAL_THREE_D.matcher(username).replaceAll(Matcher.quoteReplacement("="));
    }

    public static String authMessage(String clientFirstMessageBare, String serverFirstMessage, String clientFinalMessageWithoutProof) {
        return clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
    }

    public byte[] clientSignature(byte[] storedKey, ScramMessages.ClientFirstMessage clientFirstMessage, ScramMessages.ServerFirstMessage serverFirstMessage, ScramMessages.ClientFinalMessage clientFinalMessage) throws InvalidKeyException {
        byte[] authMessage = this.authMessage(clientFirstMessage, serverFirstMessage, clientFinalMessage);
        return this.hmac(storedKey, authMessage);
    }

    public byte[] clientProof(byte[] saltedPassword, ScramMessages.ClientFirstMessage clientFirstMessage, ScramMessages.ServerFirstMessage serverFirstMessage, ScramMessages.ClientFinalMessage clientFinalMessage) throws InvalidKeyException {
        byte[] clientKey = this.clientKey(saltedPassword);
        byte[] storedKey = this.hash(clientKey);
        byte[] clientSignature = this.hmac(storedKey, this.authMessage(clientFirstMessage, serverFirstMessage, clientFinalMessage));
        return ScramFormatter.xor(clientKey, clientSignature);
    }

    private byte[] authMessage(ScramMessages.ClientFirstMessage clientFirstMessage, ScramMessages.ServerFirstMessage serverFirstMessage, ScramMessages.ClientFinalMessage clientFinalMessage) {
        return ScramFormatter.toBytes(ScramFormatter.authMessage(clientFirstMessage.clientFirstMessageBare(), serverFirstMessage.toMessage(), clientFinalMessage.clientFinalMessageWithoutProof()));
    }

    public byte[] storedKey(byte[] clientSignature, byte[] clientProof) {
        return this.hash(ScramFormatter.xor(clientSignature, clientProof));
    }

    public byte[] serverKey(byte[] saltedPassword) throws InvalidKeyException {
        return this.hmac(saltedPassword, ScramFormatter.toBytes("Server Key"));
    }

    public byte[] serverSignature(byte[] serverKey, ScramMessages.ClientFirstMessage clientFirstMessage, ScramMessages.ServerFirstMessage serverFirstMessage, ScramMessages.ClientFinalMessage clientFinalMessage) throws InvalidKeyException {
        byte[] authMessage = this.authMessage(clientFirstMessage, serverFirstMessage, clientFinalMessage);
        return this.hmac(serverKey, authMessage);
    }

    public String secureRandomString() {
        return ScramFormatter.secureRandomString(this.random);
    }

    public static String secureRandomString(SecureRandom random) {
        return new BigInteger(130, random).toString(36);
    }

    public byte[] secureRandomBytes() {
        return ScramFormatter.secureRandomBytes(this.random);
    }

    public static byte[] secureRandomBytes(SecureRandom random) {
        return ScramFormatter.toBytes(ScramFormatter.secureRandomString(random));
    }

    public static byte[] toBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public ScramCredential generateCredential(String password, int iterations) {
        try {
            byte[] salt = this.secureRandomBytes();
            byte[] saltedPassword = this.saltedPassword(password, salt, iterations);
            return this.generateCredential(salt, saltedPassword, iterations);
        }
        catch (InvalidKeyException e) {
            throw new KafkaException("Could not create credential", e);
        }
    }

    public ScramCredential generateCredential(byte[] salt, byte[] saltedPassword, int iterations) {
        try {
            byte[] clientKey = this.clientKey(saltedPassword);
            byte[] storedKey = this.storedKey(clientKey);
            byte[] serverKey = this.serverKey(saltedPassword);
            return new ScramCredential(salt, storedKey, serverKey, iterations);
        }
        catch (InvalidKeyException e) {
            throw new KafkaException("Could not create credential", e);
        }
    }
}

