/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochResponse
extends AbstractResponse {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "An array of topics for which we have leader offsets for some requested partition leader epoch");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "An array of offsets by partition");
    private static final Field.Int64 END_OFFSET = new Field.Int64("end_offset", "The end offset");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, END_OFFSET);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V0 = new Schema(TOPICS_V0);
    private static final Field PARTITIONS_V1 = PARTITIONS.withFields(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, CommonFields.LEADER_EPOCH, END_OFFSET);
    private static final Field TOPICS_V1 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V1);
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V1 = new Schema(TOPICS_V1);
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V2;
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V3;
    private final int throttleTimeMs;
    private final Map<TopicPartition, EpochEndOffset> epochEndOffsetsByPartition;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FOR_LEADER_EPOCH_RESPONSE_V0, OFFSET_FOR_LEADER_EPOCH_RESPONSE_V1, OFFSET_FOR_LEADER_EPOCH_RESPONSE_V2, OFFSET_FOR_LEADER_EPOCH_RESPONSE_V3};
    }

    public OffsetsForLeaderEpochResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.epochEndOffsetsByPartition = new HashMap<TopicPartition, EpochEndOffset>();
        for (Object topicAndEpocsObj : struct.get(TOPICS)) {
            Struct topicAndEpochs = (Struct)topicAndEpocsObj;
            String topic = topicAndEpochs.get(CommonFields.TOPIC_NAME);
            for (Object partitionAndEpochObj : topicAndEpochs.get(PARTITIONS)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                Errors error = Errors.forCode(partitionAndEpoch.get(CommonFields.ERROR_CODE));
                int partitionId = partitionAndEpoch.get(CommonFields.PARTITION_ID);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                int leaderEpoch = partitionAndEpoch.getOrElse(CommonFields.LEADER_EPOCH, -1);
                long endOffset = partitionAndEpoch.get(END_OFFSET);
                this.epochEndOffsetsByPartition.put(tp, new EpochEndOffset(error, leaderEpoch, endOffset));
            }
        }
    }

    public OffsetsForLeaderEpochResponse(Map<TopicPartition, EpochEndOffset> epochsByTopic) {
        this(0, epochsByTopic);
    }

    public OffsetsForLeaderEpochResponse(int throttleTimeMs, Map<TopicPartition, EpochEndOffset> epochsByTopic) {
        this.throttleTimeMs = throttleTimeMs;
        this.epochEndOffsetsByPartition = epochsByTopic;
    }

    public Map<TopicPartition, EpochEndOffset> responses() {
        return this.epochEndOffsetsByPartition;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.epochEndOffsetsByPartition.values().forEach(response -> this.updateErrorCounts(errorCounts, response.error()));
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public static OffsetsForLeaderEpochResponse parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochResponse(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(versionId).read(buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct responseStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(version));
        responseStruct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, EpochEndOffset>> endOffsetsByTopic = CollectionUtils.groupPartitionDataByTopic(this.epochEndOffsetsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>(endOffsetsByTopic.size());
        for (Map.Entry<String, Map<Integer, EpochEndOffset>> topicToPartitionEpochs : endOffsetsByTopic.entrySet()) {
            Struct topicStruct = responseStruct.instance(TOPICS);
            topicStruct.set(CommonFields.TOPIC_NAME, topicToPartitionEpochs.getKey());
            Map<Integer, EpochEndOffset> partitionEpochs = topicToPartitionEpochs.getValue();
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, EpochEndOffset> partitionEndOffset : partitionEpochs.entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS);
                partitionStruct.set(CommonFields.ERROR_CODE, partitionEndOffset.getValue().error().code());
                partitionStruct.set(CommonFields.PARTITION_ID, partitionEndOffset.getKey());
                partitionStruct.setIfExists(CommonFields.LEADER_EPOCH, (Object)partitionEndOffset.getValue().leaderEpoch());
                partitionStruct.set(END_OFFSET, partitionEndOffset.getValue().endOffset());
                partitions.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS, partitions.toArray());
            topics.add(topicStruct);
        }
        responseStruct.set(TOPICS, topics.toArray());
        return responseStruct;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(type=OffsetsForLeaderEpochResponse, ").append(", throttleTimeMs=").append(this.throttleTimeMs).append(", epochEndOffsetsByPartition=").append(this.epochEndOffsetsByPartition).append(")");
        return bld.toString();
    }

    static {
        OFFSET_FOR_LEADER_EPOCH_RESPONSE_V3 = OFFSET_FOR_LEADER_EPOCH_RESPONSE_V2 = new Schema(CommonFields.THROTTLE_TIME_MS, TOPICS_V1);
    }
}

