/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.OffsetFetchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetFetchRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(OffsetFetchRequest.class);
    private static final List<OffsetFetchRequestData.OffsetFetchRequestTopic> ALL_TOPIC_PARTITIONS = null;
    public final OffsetFetchRequestData data;

    public List<TopicPartition> partitions() {
        if (this.isAllPartitions()) {
            return null;
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (OffsetFetchRequestData.OffsetFetchRequestTopic topic : this.data.topics()) {
            for (Integer partitionIndex : topic.partitionIndexes()) {
                partitions.add(new TopicPartition(topic.name(), partitionIndex));
            }
        }
        return partitions;
    }

    public String groupId() {
        return this.data.groupId();
    }

    public boolean requireStable() {
        return this.data.requireStable();
    }

    private OffsetFetchRequest(OffsetFetchRequestData data, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        this.data = data;
    }

    public OffsetFetchRequest(Struct struct, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        this.data = new OffsetFetchRequestData(struct, version);
    }

    public OffsetFetchResponse getErrorResponse(Errors error) {
        return this.getErrorResponse(0, error);
    }

    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responsePartitions = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        if (this.version() < 2) {
            OffsetFetchResponse.PartitionData partitionError = new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", error);
            for (OffsetFetchRequestData.OffsetFetchRequestTopic topic : this.data.topics()) {
                for (int partitionIndex : topic.partitionIndexes()) {
                    responsePartitions.put(new TopicPartition(topic.name(), partitionIndex), partitionError);
                }
            }
        }
        if (this.version() >= 3) {
            return new OffsetFetchResponse(throttleTimeMs, error, responsePartitions);
        }
        return new OffsetFetchResponse(error, responsePartitions);
    }

    @Override
    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public static OffsetFetchRequest parse(ByteBuffer buffer, short version) {
        return new OffsetFetchRequest(ApiKeys.OFFSET_FETCH.parseRequest(version, buffer), version);
    }

    public boolean isAllPartitions() {
        return this.data.topics() == ALL_TOPIC_PARTITIONS;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetFetchRequest> {
        public final OffsetFetchRequestData data;
        private final boolean throwOnFetchStableOffsetsUnsupported;

        public Builder(String groupId, boolean requireStable, List<TopicPartition> partitions, boolean throwOnFetchStableOffsetsUnsupported) {
            super(ApiKeys.OFFSET_FETCH);
            ArrayList topics;
            if (partitions != null) {
                HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopic> offsetFetchRequestTopicMap = new HashMap<String, OffsetFetchRequestData.OffsetFetchRequestTopic>();
                for (TopicPartition topicPartition : partitions) {
                    String topicName = topicPartition.topic();
                    OffsetFetchRequestData.OffsetFetchRequestTopic topic = offsetFetchRequestTopicMap.getOrDefault(topicName, new OffsetFetchRequestData.OffsetFetchRequestTopic().setName(topicName));
                    topic.partitionIndexes().add(topicPartition.partition());
                    offsetFetchRequestTopicMap.put(topicName, topic);
                }
                topics = new ArrayList(offsetFetchRequestTopicMap.values());
            } else {
                topics = ALL_TOPIC_PARTITIONS;
            }
            this.data = new OffsetFetchRequestData().setGroupId(groupId).setRequireStable(requireStable).setTopics(topics);
            this.throwOnFetchStableOffsetsUnsupported = throwOnFetchStableOffsetsUnsupported;
        }

        boolean isAllTopicPartitions() {
            return this.data.topics() == ALL_TOPIC_PARTITIONS;
        }

        @Override
        public OffsetFetchRequest build(short version) {
            if (this.isAllTopicPartitions() && version < 2) {
                throw new UnsupportedVersionException("The broker only supports OffsetFetchRequest v" + version + ", but we need v2 or newer to request all topic partitions.");
            }
            if (this.data.requireStable() && version < 7) {
                if (this.throwOnFetchStableOffsetsUnsupported) {
                    throw new UnsupportedVersionException("Broker unexpectedly doesn't support requireStable flag on version " + version);
                }
                log.trace("Fallback the requireStable flag to false as broker only supports OffsetFetchRequest version {}. Need v7 or newer to enable this feature", (Object)version);
                return new OffsetFetchRequest(this.data.setRequireStable(false), version);
            }
            return new OffsetFetchRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

