/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class OffsetCommitResponse
extends AbstractResponse {
    private final OffsetCommitResponseData data;

    public OffsetCommitResponse(OffsetCommitResponseData data) {
        this.data = data;
    }

    public OffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new OffsetCommitResponseData().setTopics(new ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    public OffsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        this(0, responseData);
    }

    public OffsetCommitResponse(Struct struct) {
        short latestVersion = (short)(OffsetCommitResponseData.SCHEMAS.length - 1);
        this.data = new OffsetCommitResponseData(struct, latestVersion);
    }

    public OffsetCommitResponse(Struct struct, short version) {
        this.data = new OffsetCommitResponseData(struct, version);
    }

    public OffsetCommitResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.data.topics().stream().flatMap(topicResult -> topicResult.partitions().stream().map(partitionResult -> Errors.forCode(partitionResult.errorCode()))));
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new OffsetCommitResponse(ApiKeys.OFFSET_COMMIT.parseResponse(version, buffer), version);
    }

    @Override
    public Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }
}

