/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.Cluster;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.Node;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message.MetadataResponseData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.RequestUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Utils;

public class MetadataResponse
extends AbstractResponse {
    public static final int NO_CONTROLLER_ID = -1;
    public static final int NO_LEADER_ID = -1;
    public static final int AUTHORIZED_OPERATIONS_OMITTED = Integer.MIN_VALUE;
    private final MetadataResponseData data;
    private volatile Holder holder;
    private final boolean hasReliableLeaderEpochs;

    public MetadataResponse(MetadataResponseData data) {
        this(data, true);
    }

    public MetadataResponse(Struct struct, short version) {
        this(new MetadataResponseData(struct, version), version >= 9);
    }

    private MetadataResponse(MetadataResponseData data, boolean hasReliableLeaderEpochs) {
        this.data = data;
        this.hasReliableLeaderEpochs = hasReliableLeaderEpochs;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (MetadataResponseData.MetadataResponseTopic metadata : this.data.topics()) {
            if (metadata.errorCode() == Errors.NONE.code()) continue;
            errors.put(metadata.name(), Errors.forCode(metadata.errorCode()));
        }
        return errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.topics().forEach(metadata -> this.updateErrorCounts(errorCounts, Errors.forCode(metadata.errorCode())));
        return errorCounts;
    }

    public Set<String> topicsByError(Errors error) {
        HashSet<String> errorTopics = new HashSet<String>();
        for (MetadataResponseData.MetadataResponseTopic metadata : this.data.topics()) {
            if (metadata.errorCode() != error.code()) continue;
            errorTopics.add(metadata.name());
        }
        return errorTopics;
    }

    public Cluster cluster() {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (TopicMetadata metadata : this.topicMetadata()) {
            if (metadata.error != Errors.NONE) continue;
            if (metadata.isInternal) {
                internalTopics.add(metadata.topic);
            }
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata) {
                partitions.add(MetadataResponse.toPartitionInfo(partitionMetadata, this.holder().brokers));
            }
        }
        return new Cluster(this.data.clusterId(), this.brokers(), partitions, this.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), this.topicsByError(Errors.INVALID_TOPIC_EXCEPTION), internalTopics, this.controller());
    }

    public static PartitionInfo toPartitionInfo(PartitionMetadata metadata, Map<Integer, Node> nodesById) {
        return new PartitionInfo(metadata.topic(), metadata.partition(), metadata.leaderId.map(nodesById::get).orElse(null), MetadataResponse.convertToNodeArray(metadata.replicaIds, nodesById), MetadataResponse.convertToNodeArray(metadata.inSyncReplicaIds, nodesById), MetadataResponse.convertToNodeArray(metadata.offlineReplicaIds, nodesById));
    }

    private static Node[] convertToNodeArray(List<Integer> replicaIds, Map<Integer, Node> nodesById) {
        return (Node[])replicaIds.stream().map(replicaId -> {
            Node node = (Node)nodesById.get(replicaId);
            if (node == null) {
                return new Node((int)replicaId, "", -1);
            }
            return node;
        }).toArray(Node[]::new);
    }

    public Optional<Integer> topicAuthorizedOperations(String topicName) {
        MetadataResponseData.MetadataResponseTopic topic = this.data.topics().find(topicName);
        if (topic == null) {
            return Optional.empty();
        }
        return Optional.of(topic.topicAuthorizedOperations());
    }

    public int clusterAuthorizedOperations() {
        return this.data.clusterAuthorizedOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder holder() {
        if (this.holder == null) {
            MetadataResponseData metadataResponseData = this.data;
            synchronized (metadataResponseData) {
                if (this.holder == null) {
                    this.holder = new Holder(this.data);
                }
            }
        }
        return this.holder;
    }

    public Collection<Node> brokers() {
        return this.holder().brokers.values();
    }

    public Map<Integer, Node> brokersById() {
        return this.holder().brokers;
    }

    public Collection<TopicMetadata> topicMetadata() {
        return this.holder().topicMetadata;
    }

    public Node controller() {
        return this.holder().controller;
    }

    public String clusterId() {
        return this.data.clusterId();
    }

    public boolean hasReliableLeaderEpochs() {
        return this.hasReliableLeaderEpochs;
    }

    public static MetadataResponse parse(ByteBuffer buffer, short version) {
        return new MetadataResponse(ApiKeys.METADATA.responseSchema(version).read(buffer), version);
    }

    public static MetadataResponse prepareResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadataList, int clusterAuthorizedOperations, short responseVersion) {
        MetadataResponseData responseData = new MetadataResponseData();
        responseData.setThrottleTimeMs(throttleTimeMs);
        brokers.forEach(broker -> responseData.brokers().add(new MetadataResponseData.MetadataResponseBroker().setNodeId(broker.id()).setHost(broker.host()).setPort(broker.port()).setRack(broker.rack())));
        responseData.setClusterId(clusterId);
        responseData.setControllerId(controllerId);
        responseData.setClusterAuthorizedOperations(clusterAuthorizedOperations);
        topicMetadataList.forEach(topicMetadata -> {
            MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic();
            metadataResponseTopic.setErrorCode(((TopicMetadata)topicMetadata).error.code()).setName(((TopicMetadata)topicMetadata).topic).setIsInternal(((TopicMetadata)topicMetadata).isInternal).setTopicAuthorizedOperations(((TopicMetadata)topicMetadata).authorizedOperations);
            for (PartitionMetadata partitionMetadata : ((TopicMetadata)topicMetadata).partitionMetadata) {
                metadataResponseTopic.partitions().add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionMetadata.error.code()).setPartitionIndex(partitionMetadata.partition()).setLeaderId(partitionMetadata.leaderId.orElse(-1)).setLeaderEpoch(partitionMetadata.leaderEpoch.orElse(-1)).setReplicaNodes(partitionMetadata.replicaIds).setIsrNodes(partitionMetadata.inSyncReplicaIds).setOfflineReplicas(partitionMetadata.offlineReplicaIds));
            }
            responseData.topics().add(metadataResponseTopic);
        });
        return new MetadataResponse(responseData.toStruct(responseVersion), responseVersion);
    }

    public static MetadataResponse prepareResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadataList, short responseVersion) {
        return MetadataResponse.prepareResponse(throttleTimeMs, brokers, clusterId, controllerId, topicMetadataList, Integer.MIN_VALUE, responseVersion);
    }

    public static MetadataResponse prepareResponse(Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata, short responseVersion) {
        return MetadataResponse.prepareResponse(0, brokers, clusterId, controllerId, topicMetadata, responseVersion);
    }

    public static MetadataResponse prepareResponse(Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        return MetadataResponse.prepareResponse(0, brokers, clusterId, controllerId, topicMetadata, ApiKeys.METADATA.latestVersion());
    }

    public static MetadataResponse prepareResponse(int throttleTimeMs, List<MetadataResponseData.MetadataResponseTopic> topicMetadataList, Collection<Node> brokers, String clusterId, int controllerId, int clusterAuthorizedOperations) {
        MetadataResponseData responseData = new MetadataResponseData();
        responseData.setThrottleTimeMs(throttleTimeMs);
        brokers.forEach(broker -> responseData.brokers().add(new MetadataResponseData.MetadataResponseBroker().setNodeId(broker.id()).setHost(broker.host()).setPort(broker.port()).setRack(broker.rack())));
        responseData.setClusterId(clusterId);
        responseData.setControllerId(controllerId);
        responseData.setClusterAuthorizedOperations(clusterAuthorizedOperations);
        topicMetadataList.forEach(topicMetadata -> responseData.topics().add(topicMetadata));
        return new MetadataResponse(responseData);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    private static class Holder {
        private final Map<Integer, Node> brokers;
        private final Node controller;
        private final Collection<TopicMetadata> topicMetadata;

        Holder(MetadataResponseData data) {
            this.brokers = Collections.unmodifiableMap(this.createBrokers(data));
            this.topicMetadata = this.createTopicMetadata(data);
            this.controller = this.brokers.get(data.controllerId());
        }

        private Map<Integer, Node> createBrokers(MetadataResponseData data) {
            return data.brokers().valuesList().stream().map(b -> new Node(b.nodeId(), b.host(), b.port(), b.rack())).collect(Collectors.toMap(Node::id, Function.identity()));
        }

        private Collection<TopicMetadata> createTopicMetadata(MetadataResponseData data) {
            ArrayList<TopicMetadata> topicMetadataList = new ArrayList<TopicMetadata>();
            for (MetadataResponseData.MetadataResponseTopic topicMetadata : data.topics()) {
                Errors topicError = Errors.forCode(topicMetadata.errorCode());
                String topic = topicMetadata.name();
                boolean isInternal = topicMetadata.isInternal();
                ArrayList<PartitionMetadata> partitionMetadataList = new ArrayList<PartitionMetadata>();
                for (MetadataResponseData.MetadataResponsePartition partitionMetadata : topicMetadata.partitions()) {
                    Errors partitionError = Errors.forCode(partitionMetadata.errorCode());
                    int partitionIndex = partitionMetadata.partitionIndex();
                    int leaderId = partitionMetadata.leaderId();
                    Optional<Integer> leaderIdOpt = leaderId < 0 ? Optional.empty() : Optional.of(leaderId);
                    Optional<Integer> leaderEpoch = RequestUtils.getLeaderEpoch(partitionMetadata.leaderEpoch());
                    TopicPartition topicPartition = new TopicPartition(topic, partitionIndex);
                    partitionMetadataList.add(new PartitionMetadata(partitionError, topicPartition, leaderIdOpt, leaderEpoch, partitionMetadata.replicaNodes(), partitionMetadata.isrNodes(), partitionMetadata.offlineReplicas()));
                }
                topicMetadataList.add(new TopicMetadata(topicError, topic, isInternal, partitionMetadataList, topicMetadata.topicAuthorizedOperations()));
            }
            return topicMetadataList;
        }
    }

    public static class PartitionMetadata {
        public final TopicPartition topicPartition;
        public final Errors error;
        public final Optional<Integer> leaderId;
        public final Optional<Integer> leaderEpoch;
        public final List<Integer> replicaIds;
        public final List<Integer> inSyncReplicaIds;
        public final List<Integer> offlineReplicaIds;

        public PartitionMetadata(Errors error, TopicPartition topicPartition, Optional<Integer> leaderId, Optional<Integer> leaderEpoch, List<Integer> replicaIds, List<Integer> inSyncReplicaIds, List<Integer> offlineReplicaIds) {
            this.error = error;
            this.topicPartition = topicPartition;
            this.leaderId = leaderId;
            this.leaderEpoch = leaderEpoch;
            this.replicaIds = replicaIds;
            this.inSyncReplicaIds = inSyncReplicaIds;
            this.offlineReplicaIds = offlineReplicaIds;
        }

        public int partition() {
            return this.topicPartition.partition();
        }

        public String topic() {
            return this.topicPartition.topic();
        }

        public PartitionMetadata withoutLeaderEpoch() {
            return new PartitionMetadata(this.error, this.topicPartition, this.leaderId, Optional.empty(), this.replicaIds, this.inSyncReplicaIds, this.offlineReplicaIds);
        }

        public String toString() {
            return "PartitionMetadata(error=" + (Object)((Object)this.error) + ", partition=" + this.topicPartition + ", leader=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ", replicas=" + Utils.join(this.replicaIds, ",") + ", isr=" + Utils.join(this.inSyncReplicaIds, ",") + ", offlineReplicas=" + Utils.join(this.offlineReplicaIds, ",") + ')';
        }
    }

    public static class TopicMetadata {
        private final Errors error;
        private final String topic;
        private final boolean isInternal;
        private final List<PartitionMetadata> partitionMetadata;
        private int authorizedOperations;

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata, int authorizedOperations) {
            this.error = error;
            this.topic = topic;
            this.isInternal = isInternal;
            this.partitionMetadata = partitionMetadata;
            this.authorizedOperations = authorizedOperations;
        }

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata) {
            this(error, topic, isInternal, partitionMetadata, Integer.MIN_VALUE);
        }

        public Errors error() {
            return this.error;
        }

        public String topic() {
            return this.topic;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<PartitionMetadata> partitionMetadata() {
            return this.partitionMetadata;
        }

        public void authorizedOperations(int authorizedOperations) {
            this.authorizedOperations = authorizedOperations;
        }

        public int authorizedOperations() {
            return this.authorizedOperations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicMetadata that = (TopicMetadata)o;
            return this.isInternal == that.isInternal && this.error == that.error && Objects.equals(this.topic, that.topic) && Objects.equals(this.partitionMetadata, that.partitionMetadata) && Objects.equals(this.authorizedOperations, that.authorizedOperations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.error, this.topic, this.isInternal, this.partitionMetadata, this.authorizedOperations});
        }

        public String toString() {
            return "TopicMetadata{error=" + (Object)((Object)this.error) + ", topic='" + this.topic + '\'' + ", isInternal=" + this.isInternal + ", partitionMetadata=" + this.partitionMetadata + ", authorizedOperations=" + this.authorizedOperations + '}';
        }
    }
}

