/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class ListOffsetResponse
extends AbstractResponse {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final long UNKNOWN_OFFSET = -1L;
    public static final int UNKNOWN_EPOCH = -1;
    private final ListOffsetResponseData data;

    public ListOffsetResponse(ListOffsetResponseData data) {
        this.data = data;
    }

    public ListOffsetResponse(Struct struct, short version) {
        this.data = new ListOffsetResponseData(struct, version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public ListOffsetResponseData data() {
        return this.data;
    }

    public List<ListOffsetResponseData.ListOffsetTopicResponse> topics() {
        return this.data.topics();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(errorCounts, Errors.forCode(partition.errorCode()))));
        return errorCounts;
    }

    public static ListOffsetResponse parse(ByteBuffer buffer, short version) {
        return new ListOffsetResponse(ApiKeys.LIST_OFFSETS.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }

    public static ListOffsetResponseData.ListOffsetTopicResponse singletonListOffsetTopicResponse(TopicPartition tp, Errors error, long timestamp, long offset, int epoch) {
        return new ListOffsetResponseData.ListOffsetTopicResponse().setName(tp.topic()).setPartitions(Collections.singletonList(new ListOffsetResponseData.ListOffsetPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(error.code()).setTimestamp(timestamp).setOffset(offset).setLeaderEpoch(epoch)));
    }
}

