/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.requests;

import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Errors;

public class EpochEndOffset {
    public static final long UNDEFINED_EPOCH_OFFSET = -1L;
    public static final int UNDEFINED_EPOCH = -1;
    private Errors error;
    private int leaderEpoch;
    private long endOffset;

    public EpochEndOffset(Errors error, int leaderEpoch, long endOffset) {
        this.error = error;
        this.leaderEpoch = leaderEpoch;
        this.endOffset = endOffset;
    }

    public EpochEndOffset(int leaderEpoch, long endOffset) {
        this(Errors.NONE, leaderEpoch, endOffset);
    }

    public Errors error() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public String toString() {
        return "EpochEndOffset{error=" + (Object)((Object)this.error) + ", leaderEpoch=" + this.leaderEpoch + ", endOffset=" + this.endOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EpochEndOffset that = (EpochEndOffset)o;
        return Objects.equals((Object)this.error, (Object)that.error) && Objects.equals(this.leaderEpoch, that.leaderEpoch) && Objects.equals(this.endOffset, that.endOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.error, this.leaderEpoch, this.endOffset});
    }

    public boolean hasUndefinedEpochOrOffset() {
        return this.endOffset == -1L || this.leaderEpoch == -1;
    }
}

