/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.InvalidRecordException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ControlRecordType {
    ABORT(0),
    COMMIT(1),
    QUORUM_REASSIGNMENT(2),
    LEADER_CHANGE(3),
    UNKNOWN(-1);

    private static final Logger log;
    static final short CURRENT_CONTROL_RECORD_KEY_VERSION = 0;
    static final int CURRENT_CONTROL_RECORD_KEY_SIZE = 4;
    private static final Schema CONTROL_RECORD_KEY_SCHEMA_VERSION_V0;
    final short type;

    private ControlRecordType(short type) {
        this.type = type;
    }

    public Struct recordKey() {
        if (this == UNKNOWN) {
            throw new IllegalArgumentException("Cannot serialize UNKNOWN control record type");
        }
        Struct struct = new Struct(CONTROL_RECORD_KEY_SCHEMA_VERSION_V0);
        struct.set("version", (Object)0);
        struct.set("type", (Object)this.type);
        return struct;
    }

    public static short parseTypeId(ByteBuffer key) {
        if (key.remaining() < 4) {
            throw new InvalidRecordException("Invalid value size found for end control record key. Must have at least 4 bytes, but found only " + key.remaining());
        }
        short version = key.getShort(0);
        if (version < 0) {
            throw new InvalidRecordException("Invalid version found for control record: " + version + ". May indicate data corruption");
        }
        if (version != 0) {
            log.debug("Received unknown control record key version {}. Parsing as version {}", (Object)version, (Object)0);
        }
        return key.getShort(2);
    }

    public static ControlRecordType fromTypeId(short typeId) {
        switch (typeId) {
            case 0: {
                return ABORT;
            }
            case 1: {
                return COMMIT;
            }
            case 2: {
                return QUORUM_REASSIGNMENT;
            }
            case 3: {
                return LEADER_CHANGE;
            }
        }
        return UNKNOWN;
    }

    public static ControlRecordType parse(ByteBuffer key) {
        return ControlRecordType.fromTypeId(ControlRecordType.parseTypeId(key));
    }

    static {
        log = LoggerFactory.getLogger(ControlRecordType.class);
        CONTROL_RECORD_KEY_SCHEMA_VERSION_V0 = new Schema(new Field("version", Type.INT16), new Field("type", Type.INT16));
    }
}

