/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.network.ByteBufferSend;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.network.Send;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.record.BaseRecords;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.ByteUtils;

public class RecordsWritable
implements Writable {
    private final String dest;
    private final Consumer<Send> sendConsumer;
    private final ByteBuffer buffer;
    private int mark;

    public RecordsWritable(String dest, int messageSizeExcludingRecords, Consumer<Send> sendConsumer) {
        this.dest = dest;
        this.sendConsumer = sendConsumer;
        this.buffer = ByteBuffer.allocate(messageSizeExcludingRecords);
        this.mark = 0;
    }

    @Override
    public void writeByte(byte val) {
        this.buffer.put(val);
    }

    @Override
    public void writeShort(short val) {
        this.buffer.putShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.buffer.putInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buffer.putLong(val);
    }

    @Override
    public void writeDouble(double val) {
        ByteUtils.writeDouble(val, this.buffer);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buffer.put(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteUtils.writeUnsignedVarint(i, this.buffer);
    }

    @Override
    public void writeByteBuffer(ByteBuffer src) {
        this.buffer.put(src);
    }

    public void writeRecords(BaseRecords records) {
        this.flush();
        this.sendConsumer.accept(records.toSend(this.dest));
    }

    public void flush() {
        int end = this.buffer.position();
        int len = end - this.mark;
        if (len > 0) {
            int limit = this.buffer.limit();
            this.buffer.position(this.mark);
            this.buffer.limit(end);
            ByteBuffer slice = this.buffer.slice();
            this.buffer.limit(limit);
            this.buffer.position(end);
            this.mark = end;
            ByteBufferSend send = new ByteBufferSend(this.dest, slice);
            this.sendConsumer.accept(send);
        }
    }
}

