/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;

public final class MessageUtil {
    public static final UUID ZERO_UUID = new UUID(0L, 0L);

    public static byte[] byteBufferToArray(ByteBuffer buf) {
        byte[] arr = new byte[buf.remaining()];
        int prevPosition = buf.position();
        try {
            buf.get(arr);
        }
        finally {
            buf.position(prevPosition);
        }
        return arr;
    }

    public static String deepToString(Iterator<?> iter) {
        StringBuilder bld = new StringBuilder("[");
        String prefix = "";
        while (iter.hasNext()) {
            Object object = iter.next();
            bld.append(prefix);
            bld.append(object.toString());
            prefix = ", ";
        }
        bld.append("]");
        return bld.toString();
    }

    public static byte jsonNodeToByte(JsonNode node, String about) {
        int value = MessageUtil.jsonNodeToInt(node, about);
        if (value > 127) {
            if (value <= 256) {
                value -= 128;
            } else {
                throw new RuntimeException(about + ": value " + value + " does not fit in an 8-bit signed integer.");
            }
        }
        if (value < -128) {
            throw new RuntimeException(about + ": value " + value + " does not fit in an 8-bit signed integer.");
        }
        return (byte)value;
    }

    public static short jsonNodeToShort(JsonNode node, String about) {
        int value = MessageUtil.jsonNodeToInt(node, about);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new RuntimeException(about + ": value " + value + " does not fit in a 16-bit signed integer.");
        }
        return (short)value;
    }

    public static int jsonNodeToInt(JsonNode node, String about) {
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isTextual()) {
            throw new NumberFormatException(about + ": expected an integer or string type, but got " + (Object)((Object)node.getNodeType()));
        }
        String text = node.asText();
        if (text.startsWith("0x")) {
            try {
                return Integer.parseInt(text.substring(2), 16);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(about + ": failed to parse hexadecimal number: " + e.getMessage());
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(about + ": failed to parse number: " + e.getMessage());
        }
    }

    public static long jsonNodeToLong(JsonNode node, String about) {
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            throw new NumberFormatException(about + ": expected an integer or string type, but got " + (Object)((Object)node.getNodeType()));
        }
        String text = node.asText();
        if (text.startsWith("0x")) {
            try {
                return Long.parseLong(text.substring(2), 16);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(about + ": failed to parse hexadecimal number: " + e.getMessage());
            }
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(about + ": failed to parse number: " + e.getMessage());
        }
    }

    public static byte[] jsonNodeToBinary(JsonNode node, String about) {
        if (!node.isBinary()) {
            throw new RuntimeException(about + ": expected Base64-encoded binary data.");
        }
        try {
            byte[] value = node.binaryValue();
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(about + ": unable to retrieve Base64-encoded binary data", e);
        }
    }

    public static double jsonNodeToDouble(JsonNode node, String about) {
        if (!node.isFloatingPointNumber()) {
            throw new NumberFormatException(about + ": expected a floating point type, but got " + (Object)((Object)node.getNodeType()));
        }
        return node.asDouble();
    }

    public static byte[] duplicate(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] newArray = new byte[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static boolean compareRawTaggedFields(List<RawTaggedField> first, List<RawTaggedField> second) {
        if (first == null) {
            return second == null || second.isEmpty();
        }
        if (second == null) {
            return first.isEmpty();
        }
        return first.equals(second);
    }
}

