/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.metrics.stats;

import java.util.concurrent.TimeUnit;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.metrics.internals.MetricsUtils;

public class TokenBucket
implements MeasurableStat {
    private final TimeUnit unit;
    private double tokens;
    private long lastUpdateMs;

    public TokenBucket() {
        this(TimeUnit.SECONDS);
    }

    public TokenBucket(TimeUnit unit) {
        this.unit = unit;
        this.tokens = 0.0;
        this.lastUpdateMs = 0L;
    }

    @Override
    public double measure(MetricConfig config, long timeMs) {
        if (config.quota() == null) {
            return 9.223372036854776E18;
        }
        double quota = config.quota().bound();
        double burst = this.burst(config);
        this.refill(quota, burst, timeMs);
        return this.tokens;
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        if (config.quota() == null) {
            return;
        }
        double quota = config.quota().bound();
        double burst = this.burst(config);
        this.refill(quota, burst, timeMs);
        this.tokens = Math.min(burst, this.tokens - value);
    }

    private void refill(double quota, double burst, long timeMs) {
        this.tokens = Math.min(burst, this.tokens + quota * MetricsUtils.convert(timeMs - this.lastUpdateMs, this.unit));
        this.lastUpdateMs = timeMs;
    }

    private double burst(MetricConfig config) {
        return (double)config.samples() * MetricsUtils.convert(config.timeWindowMs(), this.unit) * config.quota().bound();
    }
}

