/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.utils.Bytes;

public class DescribeDelegationTokenResponseData
implements ApiMessage {
    short errorCode;
    List<DescribedDelegationToken> tokens;
    int throttleTimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public DescribeDelegationTokenResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeDelegationTokenResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeDelegationTokenResponseData() {
        this.errorCode = 0;
        this.tokens = new ArrayList<DescribedDelegationToken>(0);
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 41;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribedDelegationToken> newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field tokens was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedDelegationToken(_readable, _version));
            }
            this.tokens = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field tokens was serialized as null");
            }
            newCollection = new ArrayList<DescribedDelegationToken>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribedDelegationToken(_readable, _version));
            }
            this.tokens = newCollection;
        }
        this.throttleTimeMs = _readable.readInt();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.tokens.size() + 1);
            for (DescribedDelegationToken tokensElement : this.tokens) {
                tokensElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.tokens.size());
            for (DescribedDelegationToken tokensElement : this.tokens) {
                tokensElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.throttleTimeMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("tokens");
        this.tokens = new ArrayList<DescribedDelegationToken>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.tokens.add(new DescribedDelegationToken((Struct)nestedObject, _version));
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.tokens.size()];
        int i = 0;
        for (DescribedDelegationToken element : this.tokens) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("tokens", (Object)_nestedObjects);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.tokens.size() + 1)) : (_arraySize += 4);
        for (DescribedDelegationToken tokensElement : this.tokens) {
            _arraySize += tokensElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeDelegationTokenResponseData)) {
            return false;
        }
        DescribeDelegationTokenResponseData other = (DescribeDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.tokens == null ? 0 : this.tokens.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    @Override
    public DescribeDelegationTokenResponseData duplicate() {
        DescribeDelegationTokenResponseData _duplicate = new DescribeDelegationTokenResponseData();
        _duplicate.errorCode = this.errorCode;
        ArrayList<DescribedDelegationToken> newTokens = new ArrayList<DescribedDelegationToken>(this.tokens.size());
        for (DescribedDelegationToken _element : this.tokens) {
            newTokens.add(_element.duplicate());
        }
        _duplicate.tokens = newTokens;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        return _duplicate;
    }

    public String toString() {
        return "DescribeDelegationTokenResponseData(errorCode=" + this.errorCode + ", tokens=" + MessageUtil.deepToString(this.tokens.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<DescribedDelegationToken> tokens() {
        return this.tokens;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setTokens(List<DescribedDelegationToken> v) {
        this.tokens = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new ArrayOf(DescribedDelegationToken.SCHEMA_0), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new CompactArrayOf(DescribedDelegationToken.SCHEMA_2), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribedDelegationTokenRenewer
    implements Message {
        String principalType;
        String principalName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public DescribedDelegationTokenRenewer(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedDelegationTokenRenewer(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribedDelegationTokenRenewer() {
            this.principalType = "";
            this.principalName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationTokenRenewer");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalType had invalid length " + length);
            }
            this.principalType = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalName had invalid length " + length);
            }
            this.principalName = _readable.readString(length);
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.principalType);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.principalName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationTokenRenewer");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribedDelegationTokenRenewer");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedDelegationTokenRenewer");
            }
            byte[] _stringBytes = this.principalType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalType, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _stringBytes = this.principalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalName, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationTokenRenewer)) {
                return false;
            }
            DescribedDelegationTokenRenewer other = (DescribedDelegationTokenRenewer)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            return hashCode;
        }

        @Override
        public DescribedDelegationTokenRenewer duplicate() {
            DescribedDelegationTokenRenewer _duplicate = new DescribedDelegationTokenRenewer();
            _duplicate.principalType = this.principalType;
            _duplicate.principalName = this.principalName;
            return _duplicate;
        }

        public String toString() {
            return "DescribedDelegationTokenRenewer(principalType=" + (this.principalType == null ? "null" : "'" + this.principalType.toString() + "'") + ", principalName=" + (this.principalName == null ? "null" : "'" + this.principalName.toString() + "'") + ")";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedDelegationTokenRenewer setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationTokenRenewer setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The renewer principal type"), new Field("principal_name", Type.STRING, "The renewer principal name"));
            SCHEMA_2 = new Schema(new Field("principal_type", Type.COMPACT_STRING, "The renewer principal type"), new Field("principal_name", Type.COMPACT_STRING, "The renewer principal name"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DescribedDelegationToken
    implements Message {
        String principalType;
        String principalName;
        long issueTimestamp;
        long expiryTimestamp;
        long maxTimestamp;
        String tokenId;
        byte[] hmac;
        List<DescribedDelegationTokenRenewer> renewers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public DescribedDelegationToken(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedDelegationToken(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribedDelegationToken() {
            this.principalType = "";
            this.principalName = "";
            this.issueTimestamp = 0L;
            this.expiryTimestamp = 0L;
            this.maxTimestamp = 0L;
            this.tokenId = "";
            this.hmac = Bytes.EMPTY;
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<DescribedDelegationTokenRenewer> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationToken");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalType had invalid length " + length);
            }
            this.principalType = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principalName had invalid length " + length);
            }
            this.principalName = _readable.readString(length);
            this.issueTimestamp = _readable.readLong();
            this.expiryTimestamp = _readable.readLong();
            this.maxTimestamp = _readable.readLong();
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field tokenId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field tokenId had invalid length " + length);
            }
            this.tokenId = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field hmac was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.hmac = newBytes;
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field renewers was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedDelegationTokenRenewer(_readable, _version));
                }
                this.renewers = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field renewers was serialized as null");
                }
                newCollection = new ArrayList<DescribedDelegationTokenRenewer>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new DescribedDelegationTokenRenewer(_readable, _version));
                }
                this.renewers = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.principalType);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.principalName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeLong(this.issueTimestamp);
            _writable.writeLong(this.expiryTimestamp);
            _writable.writeLong(this.maxTimestamp);
            _stringBytes = _cache.getSerializedValue(this.tokenId);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.hmac.length + 1);
            } else {
                _writable.writeInt(this.hmac.length);
            }
            _writable.writeByteArray(this.hmac);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.renewers.size() + 1);
                _stringBytes = this.renewers.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedDelegationTokenRenewer renewersElement = (DescribedDelegationTokenRenewer)_stringBytes.next();
                    renewersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.renewers.size());
                _stringBytes = this.renewers.iterator();
                while (_stringBytes.hasNext()) {
                    DescribedDelegationTokenRenewer renewersElement = (DescribedDelegationTokenRenewer)_stringBytes.next();
                    renewersElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedDelegationToken");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
            this.issueTimestamp = struct.getLong("issue_timestamp");
            this.expiryTimestamp = struct.getLong("expiry_timestamp");
            this.maxTimestamp = struct.getLong("max_timestamp");
            this.tokenId = struct.getString("token_id");
            this.hmac = struct.getByteArray("hmac");
            Object[] _nestedObjects = struct.getArray("renewers");
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.renewers.add(new DescribedDelegationTokenRenewer((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribedDelegationToken");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            struct.set("issue_timestamp", (Object)this.issueTimestamp);
            struct.set("expiry_timestamp", (Object)this.expiryTimestamp);
            struct.set("max_timestamp", (Object)this.maxTimestamp);
            struct.set("token_id", (Object)this.tokenId);
            struct.setByteArray("hmac", this.hmac);
            Struct[] _nestedObjects = new Struct[this.renewers.size()];
            int i = 0;
            for (DescribedDelegationTokenRenewer element : this.renewers) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("renewers", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedDelegationToken");
            }
            byte[] _stringBytes = this.principalType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalType, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _stringBytes = this.principalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principalName, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 8;
            _size += 8;
            _size += 8;
            _stringBytes = this.tokenId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'tokenId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.tokenId, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _bytesSize = this.hmac.length;
            _bytesSize = _version >= 2 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.hmac.length + 1)) : (_bytesSize += 4);
            _size += _bytesSize;
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.renewers.size() + 1)) : (_arraySize += 4);
            for (DescribedDelegationTokenRenewer renewersElement : this.renewers) {
                _arraySize += renewersElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationToken)) {
                return false;
            }
            DescribedDelegationToken other = (DescribedDelegationToken)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
                return false;
            }
            if (this.issueTimestamp != other.issueTimestamp) {
                return false;
            }
            if (this.expiryTimestamp != other.expiryTimestamp) {
                return false;
            }
            if (this.maxTimestamp != other.maxTimestamp) {
                return false;
            }
            if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
                return false;
            }
            if (!Arrays.equals(this.hmac, other.hmac)) {
                return false;
            }
            if (this.renewers == null ? other.renewers != null : !this.renewers.equals(other.renewers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            hashCode = 31 * hashCode + ((int)(this.issueTimestamp >> 32) ^ (int)this.issueTimestamp);
            hashCode = 31 * hashCode + ((int)(this.expiryTimestamp >> 32) ^ (int)this.expiryTimestamp);
            hashCode = 31 * hashCode + ((int)(this.maxTimestamp >> 32) ^ (int)this.maxTimestamp);
            hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
            hashCode = 31 * hashCode + (this.renewers == null ? 0 : this.renewers.hashCode());
            return hashCode;
        }

        @Override
        public DescribedDelegationToken duplicate() {
            DescribedDelegationToken _duplicate = new DescribedDelegationToken();
            _duplicate.principalType = this.principalType;
            _duplicate.principalName = this.principalName;
            _duplicate.issueTimestamp = this.issueTimestamp;
            _duplicate.expiryTimestamp = this.expiryTimestamp;
            _duplicate.maxTimestamp = this.maxTimestamp;
            _duplicate.tokenId = this.tokenId;
            _duplicate.hmac = MessageUtil.duplicate(this.hmac);
            ArrayList<DescribedDelegationTokenRenewer> newRenewers = new ArrayList<DescribedDelegationTokenRenewer>(this.renewers.size());
            for (DescribedDelegationTokenRenewer _element : this.renewers) {
                newRenewers.add(_element.duplicate());
            }
            _duplicate.renewers = newRenewers;
            return _duplicate;
        }

        public String toString() {
            return "DescribedDelegationToken(principalType=" + (this.principalType == null ? "null" : "'" + this.principalType.toString() + "'") + ", principalName=" + (this.principalName == null ? "null" : "'" + this.principalName.toString() + "'") + ", issueTimestamp=" + this.issueTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", tokenId=" + (this.tokenId == null ? "null" : "'" + this.tokenId.toString() + "'") + ", hmac=" + Arrays.toString(this.hmac) + ", renewers=" + MessageUtil.deepToString(this.renewers.iterator()) + ")";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public long issueTimestamp() {
            return this.issueTimestamp;
        }

        public long expiryTimestamp() {
            return this.expiryTimestamp;
        }

        public long maxTimestamp() {
            return this.maxTimestamp;
        }

        public String tokenId() {
            return this.tokenId;
        }

        public byte[] hmac() {
            return this.hmac;
        }

        public List<DescribedDelegationTokenRenewer> renewers() {
            return this.renewers;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedDelegationToken setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationToken setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        public DescribedDelegationToken setIssueTimestamp(long v) {
            this.issueTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setExpiryTimestamp(long v) {
            this.expiryTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setMaxTimestamp(long v) {
            this.maxTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setTokenId(String v) {
            this.tokenId = v;
            return this;
        }

        public DescribedDelegationToken setHmac(byte[] v) {
            this.hmac = v;
            return this;
        }

        public DescribedDelegationToken setRenewers(List<DescribedDelegationTokenRenewer> v) {
            this.renewers = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The token principal type."), new Field("principal_name", Type.STRING, "The token principal name."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.STRING, "The token ID."), new Field("hmac", Type.BYTES, "The token HMAC."), new Field("renewers", new ArrayOf(DescribedDelegationTokenRenewer.SCHEMA_0), "Those who are able to renew this token before it expires."));
            SCHEMA_2 = new Schema(new Field("principal_type", Type.COMPACT_STRING, "The token principal type."), new Field("principal_name", Type.COMPACT_STRING, "The token principal name."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.COMPACT_STRING, "The token ID."), new Field("hmac", Type.COMPACT_BYTES, "The token HMAC."), new Field("renewers", new CompactArrayOf(DescribedDelegationTokenRenewer.SCHEMA_2), "Those who are able to renew this token before it expires."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

