/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.feature.BaseVersionRange;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.feature.SupportedVersionRange;

public class Features<VersionRangeType extends BaseVersionRange> {
    private final Map<String, VersionRangeType> features;

    private Features(Map<String, VersionRangeType> features) {
        Objects.requireNonNull(features, "Provided features can not be null.");
        this.features = features;
    }

    public static Features<SupportedVersionRange> supportedFeatures(Map<String, SupportedVersionRange> features) {
        return new Features<SupportedVersionRange>(features);
    }

    public static Features<FinalizedVersionRange> finalizedFeatures(Map<String, FinalizedVersionRange> features) {
        return new Features<FinalizedVersionRange>(features);
    }

    public static Features<FinalizedVersionRange> emptyFinalizedFeatures() {
        return new Features<FinalizedVersionRange>(new HashMap());
    }

    public static Features<SupportedVersionRange> emptySupportedFeatures() {
        return new Features<SupportedVersionRange>(new HashMap());
    }

    public Map<String, VersionRangeType> features() {
        return this.features;
    }

    public boolean empty() {
        return this.features.isEmpty();
    }

    public VersionRangeType get(String feature) {
        return (VersionRangeType)((BaseVersionRange)this.features.get(feature));
    }

    public String toString() {
        return String.format("Features{%s}", this.features.entrySet().stream().map(entry -> String.format("(%s -> %s)", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")));
    }

    public Map<String, Map<String, Short>> toMap() {
        return this.features.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((BaseVersionRange)entry.getValue()).toMap()));
    }

    private static <V extends BaseVersionRange> Features<V> fromFeaturesMap(Map<String, Map<String, Short>> featuresMap, MapToBaseVersionRangeConverter<V> converter) {
        return new Features<BaseVersionRange>(featuresMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> converter.fromMap((Map)entry.getValue()))));
    }

    public static Features<FinalizedVersionRange> fromFinalizedFeaturesMap(Map<String, Map<String, Short>> featuresMap) {
        return Features.fromFeaturesMap(featuresMap, FinalizedVersionRange::fromMap);
    }

    public static Features<SupportedVersionRange> fromSupportedFeaturesMap(Map<String, Map<String, Short>> featuresMap) {
        return Features.fromFeaturesMap(featuresMap, SupportedVersionRange::fromMap);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Features)) {
            return false;
        }
        Features that = (Features)other;
        return Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.features);
    }

    private static interface MapToBaseVersionRangeConverter<V extends BaseVersionRange> {
        public V fromMap(Map<String, Short> var1);
    }
}

