/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConfigValue {
    private final String name;
    private Object value;
    private List<Object> recommendedValues;
    private final List<String> errorMessages;
    private boolean visible;

    public ConfigValue(String name) {
        this(name, null, new ArrayList<Object>(), new ArrayList<String>());
    }

    public ConfigValue(String name, Object value, List<Object> recommendedValues, List<String> errorMessages) {
        this.name = name;
        this.value = value;
        this.recommendedValues = recommendedValues;
        this.errorMessages = errorMessages;
        this.visible = true;
    }

    public String name() {
        return this.name;
    }

    public Object value() {
        return this.value;
    }

    public List<Object> recommendedValues() {
        return this.recommendedValues;
    }

    public List<String> errorMessages() {
        return this.errorMessages;
    }

    public boolean visible() {
        return this.visible;
    }

    public void value(Object value) {
        this.value = value;
    }

    public void recommendedValues(List<Object> recommendedValues) {
        this.recommendedValues = recommendedValues;
    }

    public void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public void visible(boolean visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.recommendedValues, that.recommendedValues) && Objects.equals(this.errorMessages, that.errorMessages) && Objects.equals(this.visible, that.visible);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.recommendedValues, this.errorMessages, this.visible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.name).append(",").append(this.value).append(",").append(this.recommendedValues).append(",").append(this.errorMessages).append(",").append(this.visible).append("]");
        return sb.toString();
    }
}

