/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common;

import java.util.Objects;

public class Node {
    private static final Node NO_NODE = new Node(-1, "", -1);
    private final int id;
    private final String idString;
    private final String host;
    private final int port;
    private final String rack;
    private Integer hash;

    public Node(int id, String host, int port) {
        this(id, host, port, null);
    }

    public Node(int id, String host, int port, String rack) {
        this.id = id;
        this.idString = Integer.toString(id);
        this.host = host;
        this.port = port;
        this.rack = rack;
    }

    public static Node noNode() {
        return NO_NODE;
    }

    public boolean isEmpty() {
        return this.host == null || this.host.isEmpty() || this.port < 0;
    }

    public int id() {
        return this.id;
    }

    public String idString() {
        return this.idString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public String rack() {
        return this.rack;
    }

    public int hashCode() {
        Integer h = this.hash;
        if (h == null) {
            int result = 31 + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.port;
            result = 31 * result + (this.rack == null ? 0 : this.rack.hashCode());
            this.hash = result;
            return result;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id && this.port == other.port && Objects.equals(this.host, other.host) && Objects.equals(this.rack, other.rack);
    }

    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + ")";
    }
}

