/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class MetricNameTemplate {
    private final String name;
    private final String group;
    private final String description;
    private LinkedHashSet<String> tags;

    public MetricNameTemplate(String name, String group, String description, Set<String> tagsNames) {
        this.name = Objects.requireNonNull(name);
        this.group = Objects.requireNonNull(group);
        this.description = Objects.requireNonNull(description);
        this.tags = new LinkedHashSet(Objects.requireNonNull(tagsNames));
    }

    public MetricNameTemplate(String name, String group, String description, String ... tagsNames) {
        this(name, group, description, MetricNameTemplate.getTags(tagsNames));
    }

    private static LinkedHashSet<String> getTags(String ... keys) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        Collections.addAll(tags, keys);
        return tags;
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public String description() {
        return this.description;
    }

    public Set<String> tags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.group, this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricNameTemplate other = (MetricNameTemplate)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.group, other.group) && Objects.equals(this.tags, other.tags);
    }

    public String toString() {
        return String.format("name=%s, group=%s, tags=%s", this.name, this.group, this.tags);
    }
}

