/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.TopicPartition;

public class NoOffsetForPartitionException
extends InvalidOffsetException {
    private static final long serialVersionUID = 1L;
    private final Set<TopicPartition> partitions;

    public NoOffsetForPartitionException(TopicPartition partition) {
        super("Undefined offset with no reset policy for partition: " + partition);
        this.partitions = Collections.singleton(partition);
    }

    public NoOffsetForPartitionException(Collection<TopicPartition> partitions) {
        super("Undefined offset with no reset policy for partitions: " + partitions);
        this.partitions = Collections.unmodifiableSet(new HashSet<TopicPartition>(partitions));
    }

    @Deprecated
    public TopicPartition partition() {
        return this.partitions.isEmpty() ? null : this.partitions.iterator().next();
    }

    @Override
    public Set<TopicPartition> partitions() {
        return this.partitions;
    }
}

