/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.KafkaException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.acl.AclBinding;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.errors.ApiException;

@InterfaceStability.Evolving
public class DeleteAclsResult {
    private final Map<AclBindingFilter, KafkaFuture<FilterResults>> futures;

    DeleteAclsResult(Map<AclBindingFilter, KafkaFuture<FilterResults>> futures) {
        this.futures = futures;
    }

    public Map<AclBindingFilter, KafkaFuture<FilterResults>> values() {
        return this.futures;
    }

    public KafkaFuture<Collection<AclBinding>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(v -> this.getAclBindings(this.futures));
    }

    private List<AclBinding> getAclBindings(Map<AclBindingFilter, KafkaFuture<FilterResults>> futures) {
        ArrayList<AclBinding> acls = new ArrayList<AclBinding>();
        for (KafkaFuture<FilterResults> value : futures.values()) {
            FilterResults results;
            try {
                results = value.get();
            }
            catch (Throwable e) {
                throw new KafkaException("DeleteAclsResult#all: internal error", e);
            }
            for (FilterResult result : results.values()) {
                if (result.exception() != null) {
                    throw result.exception();
                }
                acls.add(result.binding());
            }
        }
        return acls;
    }

    public static class FilterResults {
        private final List<FilterResult> values;

        FilterResults(List<FilterResult> values) {
            this.values = values;
        }

        public List<FilterResult> values() {
            return this.values;
        }
    }

    public static class FilterResult {
        private final AclBinding binding;
        private final ApiException exception;

        FilterResult(AclBinding binding, ApiException exception) {
            this.binding = binding;
            this.exception = exception;
        }

        public AclBinding binding() {
            return this.binding;
        }

        public ApiException exception() {
            return this.exception;
        }
    }
}

