/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.cdc.base.util;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;

public class RecordUtils {
    private static final List<String> NUMBER_TYPE = Arrays.asList("NUMBER");
    private static final List<String> FLOAT_TYPE = Arrays.asList("FLOAT", "BINARY_FLOAT");
    private static final List<String> DOUBLE_TYPE = Arrays.asList("DOUBLE PRECISION", "BINARY_DOUBLE");
    private static final List<String> TIMESTAMP_TYPE = Arrays.asList("DATE", "TIMESTAMP", "WITH LOCAL TIME ZONE", "TIMESTAMP WITH TIME ZONE");
    private static final List<String> VARCHAR_TYPE = Arrays.asList("CHAR", "NCHAR", "NVARCHAR2", "NVCHAER", "VARCHAR", "VARCHAR2", "CLOB", "NCLOB", "XMLType");
    private static final List<String> BINARY_TYPE = Arrays.asList("BLOB", "ROWID");
    private static final List<String> BIGINT_TYPE = Arrays.asList("INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH");

    private RecordUtils() {
    }

    public static TableId getTableId(SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("source");
        String dbName = source.getString("db");
        String schemaName = source.getString("schema");
        String tableName = source.getString("table");
        return new TableId(dbName, schemaName, tableName);
    }

    public static LogicalType convertLogicType(Column column, Struct struct) {
        Integer s;
        String typeName = column.typeName();
        Integer p = column.length() == 0 ? 38 : column.length();
        Integer n = s = column.scale().isPresent() ? column.scale().orElse(0) : struct.getInt32("scale");
        if (NUMBER_TYPE.contains(typeName)) {
            if (p == 1) {
                return new BooleanType();
            }
            if (s <= 0 && p - s < 3) {
                return new TinyIntType();
            }
            if (s <= 0 && p - s < 5) {
                return new SmallIntType();
            }
            if (s <= 0 && p - s < 10) {
                return new IntType();
            }
            if (s <= 0 && p - s < 19) {
                return new BigIntType();
            }
            if (s <= 0 && p - s >= 10 && p - s <= 38) {
                return new DecimalType(p - s, 0);
            }
            if (s > 0) {
                return new DecimalType(p.intValue(), s.intValue());
            }
            if (s <= 0 && p - s > 38) {
                return new VarCharType(Integer.MAX_VALUE);
            }
        }
        if (FLOAT_TYPE.contains(typeName)) {
            return new FloatType();
        }
        if (DOUBLE_TYPE.contains(typeName)) {
            return new DoubleType();
        }
        if (TIMESTAMP_TYPE.contains(typeName)) {
            return new TimestampType(p.intValue());
        }
        if (VARCHAR_TYPE.contains(typeName)) {
            return new VarCharType(Integer.MAX_VALUE);
        }
        if (BINARY_TYPE.contains(typeName)) {
            return new BinaryType();
        }
        if (BIGINT_TYPE.contains(typeName)) {
            return new BigIntType();
        }
        return null;
    }
}

