/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.cdc.base.debezium.internal;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.engine.ChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Internal
public class Handover
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Handover.class);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private List<ChangeEvent<SourceRecord, SourceRecord>> next;
    @GuardedBy(value="lock")
    private Throwable error;
    private boolean wakeupProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeEvent<SourceRecord, SourceRecord>> pollNext() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            while (this.next == null && this.error == null) {
                this.lock.wait();
            }
            List<ChangeEvent<SourceRecord, SourceRecord>> n = this.next;
            if (n != null) {
                this.next = null;
                this.lock.notifyAll();
                return n;
            }
            ExceptionUtils.rethrowException((Throwable)this.error, (String)this.error.getMessage());
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(List<ChangeEvent<SourceRecord, SourceRecord>> element) throws InterruptedException {
        Preconditions.checkNotNull(element);
        Object object = this.lock;
        synchronized (object) {
            while (this.next != null && !this.wakeupProducer) {
                this.lock.wait();
            }
            this.wakeupProducer = false;
            if (this.error != null) {
                ExceptionUtils.rethrow((Throwable)this.error, (String)this.error.getMessage());
            } else {
                this.next = element;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(Throwable t) {
        Preconditions.checkNotNull((Object)t);
        Object object = this.lock;
        synchronized (object) {
            LOG.error("Reporting error:", t);
            if (this.error == null) {
                this.error = t;
            }
            this.next = null;
            this.lock.notifyAll();
        }
    }

    public boolean hasError() {
        return this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.next = null;
            this.wakeupProducer = false;
            if (this.error == null) {
                this.error = new ClosedException();
            }
            this.lock.notifyAll();
        }
    }

    public static final class ClosedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

