/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.sub;

import com.ververica.cdc.connectors.shaded.com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.metric.sub.SinkSubMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkTopicMetricData
extends SinkMetricData
implements SinkSubMetricData {
    public static final Logger LOGGER = LoggerFactory.getLogger(SinkTopicMetricData.class);
    private final Map<String, SinkMetricData> topicSinkMetricMap = Maps.newHashMap();

    public SinkTopicMetricData(MetricOption option, MetricGroup metricGroup) {
        super(option, metricGroup);
    }

    public void registerSubMetricsGroup(MetricState metricState) {
        if (metricState == null) {
            return;
        }
        if (metricState.getSubMetricStateMap() == null) {
            return;
        }
        Map<String, MetricState> subMetricStateMap = metricState.getSubMetricStateMap();
        for (Map.Entry<String, MetricState> subMetricStateEntry : subMetricStateMap.entrySet()) {
            String topic = subMetricStateEntry.getKey();
            MetricState subMetricState = subMetricStateEntry.getValue();
            SinkMetricData subSinkMetricData = this.buildSinkMetricData(topic, subMetricState, this);
            this.topicSinkMetricMap.put(topic, subSinkMetricData);
        }
        LOGGER.info("register topicMetricsGroup from metricState,topic level metric map size:{}", (Object)this.topicSinkMetricMap.size());
    }

    public void sendOutMetrics(String topic, long rowCount, long rowSize) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            this.invoke(rowCount, rowSize);
            return;
        }
        SinkMetricData sinkMetricData = this.getSinkMetricData(topic);
        this.invoke(rowCount, rowSize);
        sinkMetricData.invoke(rowCount, rowSize);
    }

    public void sendDirtyMetrics(String topic, long rowCount, long rowSize) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            this.invokeDirty(rowCount, rowSize);
            return;
        }
        SinkMetricData sinkMetricData = this.getSinkMetricData(topic);
        this.invokeDirty(rowCount, rowSize);
        sinkMetricData.invokeDirty(rowCount, rowSize);
    }

    private SinkMetricData getSinkMetricData(String topic) {
        SinkMetricData sinkMetricData;
        if (this.topicSinkMetricMap.containsKey(topic)) {
            sinkMetricData = this.topicSinkMetricMap.get(topic);
        } else {
            sinkMetricData = this.buildSinkMetricData(topic, null, this);
            this.topicSinkMetricMap.put(topic, sinkMetricData);
        }
        return sinkMetricData;
    }

    private SinkMetricData buildSinkMetricData(String topic, MetricState metricState, SinkMetricData sinkMetricData) {
        Map<String, String> labels = sinkMetricData.getLabels();
        String metricGroupLabels = labels.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        MetricOption metricOption = MetricOption.builder().withInlongLabels(metricGroupLabels + "&" + "topic" + "=" + topic).withInitRecords(metricState != null ? metricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(metricState != null ? metricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(metricState != null ? metricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(metricState != null ? metricState.getMetricValue("dirtyBytesOut") : 0L).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        return new SinkMetricData(metricOption, sinkMetricData.getMetricGroup());
    }

    @Override
    public Map<String, SinkMetricData> getSubSinkMetricMap() {
        return this.topicSinkMetricMap;
    }

    @Override
    public String toString() {
        return "SinkTopicMetricData{" + super.toString() + ",subSinkMetricMap=" + this.topicSinkMetricMap + '}';
    }
}

