/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.inlong.sort.base.filter.RowValidator;

public class RowKindValidator
implements RowValidator {
    private final Set<RowKind> rowKindsFiltered = new HashSet<RowKind>();
    private static final String pattern = "(\\+I|\\+U|-U|-D)(&(\\+I|\\+U|-U|-D))*";

    public RowKindValidator(List<String> rowKinds) {
        Preconditions.checkArgument((!rowKinds.isEmpty() ? 1 : 0) != 0, (Object)"rowKinds should not be empty");
        for (String rowKind : rowKinds) {
            Arrays.stream(RowKind.values()).filter(value -> value.shortString().equals(rowKind)).findFirst().ifPresent(this.rowKindsFiltered::add);
        }
    }

    public RowKindValidator(String rowKinds) {
        Preconditions.checkArgument((boolean)Pattern.matches(pattern, rowKinds), (Object)String.format("rowKinds is not valid, should match the pattern %s, the input value is %s", pattern, rowKinds));
        for (String rowKind : rowKinds.split("&")) {
            Arrays.stream(RowKind.values()).filter(value -> value.shortString().equals(rowKind)).findFirst().ifPresent(this.rowKindsFiltered::add);
        }
    }

    @Override
    public boolean validate(RowKind rowKind) {
        return this.rowKindsFiltered.contains(rowKind);
    }
}

