/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;

@FunctionalInterface
public interface Metronome {
    public void pause() throws InterruptedException;

    public static Metronome sleeper(Duration period, final Clock timeSystem) {
        final long periodInMillis = period.toMillis();
        return new Metronome(){
            private long next;
            {
                this.next = timeSystem.currentTimeInMillis() + periodInMillis;
            }

            @Override
            public void pause() throws InterruptedException {
                long now;
                while (this.next > (now = timeSystem.currentTimeInMillis())) {
                    Thread.sleep(this.next - now);
                }
                this.next += periodInMillis;
            }

            public String toString() {
                return "Metronome (sleep for " + periodInMillis + " ms)";
            }
        };
    }

    public static Metronome parker(Duration period, final Clock timeSystem) {
        final long periodInNanos = period.toNanos();
        return new Metronome(){
            private long next;
            {
                this.next = timeSystem.currentTimeInNanos() + periodInNanos;
            }

            @Override
            public void pause() throws InterruptedException {
                while (this.next > timeSystem.currentTimeInNanos()) {
                    LockSupport.parkNanos(this.next - timeSystem.currentTimeInNanos());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
                this.next += periodInNanos;
            }

            public String toString() {
                return "Metronome (park for " + TimeUnit.NANOSECONDS.toMillis(periodInNanos) + " ms)";
            }
        };
    }
}

