/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.Immutable;

@Immutable
public class Iterators {
    public static <T> Iterator<T> empty() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }
        };
    }

    public static <T> Iterator<T> with(final T value) {
        return new Iterator<T>(){
            private boolean finished = false;

            @Override
            public boolean hasNext() {
                return !this.finished;
            }

            @Override
            public T next() {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                this.finished = true;
                return value;
            }
        };
    }

    public static <T> Iterator<T> with(final T value1, final T value2) {
        return new Iterator<T>(){
            private int remaining = 2;

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            @Override
            public T next() {
                if (this.remaining == 2) {
                    --this.remaining;
                    return value1;
                }
                if (this.remaining == 1) {
                    --this.remaining;
                    return value2;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T> Iterator<T> with(final T value1, final T value2, final T value3) {
        return new Iterator<T>(){
            private int remaining = 3;

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            @Override
            public T next() {
                if (this.remaining == 3) {
                    --this.remaining;
                    return value1;
                }
                if (this.remaining == 2) {
                    --this.remaining;
                    return value2;
                }
                if (this.remaining == 1) {
                    --this.remaining;
                    return value3;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> with(final T value1, final T value2, final T value3, final T ... additional) {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < additional.length + 3;
            }

            @Override
            public T next() {
                try {
                    if (this.index == 0) {
                        Object object = value1;
                        return object;
                    }
                    if (this.index == 1) {
                        Object object = value2;
                        return object;
                    }
                    if (this.index == 2) {
                        Object object = value3;
                        return object;
                    }
                    if (this.index < additional.length + 3) {
                        Object object = additional[this.index - 3];
                        return object;
                    }
                    --this.index;
                    throw new NoSuchElementException();
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> Iterator<T> with(final T[] values) {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public T next() {
                try {
                    if (this.index < values.length) {
                        Object object = values[this.index];
                        return object;
                    }
                    --this.index;
                    throw new NoSuchElementException();
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T, U, V> Iterator<V> around(Iterable<? extends T> first, Iterable<? extends U> second, BiFunction<T, U, V> conversion) {
        return Iterators.around(first.iterator(), second.iterator(), conversion);
    }

    public static <T, U, V> Iterator<V> around(final Iterator<? extends T> first, final Iterator<? extends U> second, final BiFunction<T, U, V> combineFirstAndSecond) {
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return second.hasNext();
            }

            @Override
            public V next() {
                return combineFirstAndSecond.apply(first.next(), second.next());
            }
        };
    }

    public static <V, T> Iterator<T> around(Iterable<? extends V> iterable, Function<V, T> conversion) {
        return Iterators.around(iterable.iterator(), conversion);
    }

    public static <V, T> Iterator<T> around(final Iterator<? extends V> iterator, final Function<V, T> conversion) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return conversion.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterable<T> around(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterator<T> readOnly(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <V, T> Iterator<T> readOnly(final Iterator<? extends V> iterator, final Function<V, T> conversion) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return conversion.apply(iterator.next());
            }
        };
    }

    public static <T> Iterator<T> readOnly(Iterable<T> iterable) {
        return Iterators.readOnly(iterable.iterator());
    }

    public static <V, T> Iterator<T> readOnly(Iterable<V> iterable, Function<V, T> conversion) {
        return Iterators.readOnly(iterable.iterator(), conversion);
    }

    public static <T> Iterable<T> readOnlyIterable(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.readOnly(iterable.iterator());
            }
        };
    }

    public static <V, T> Iterable<T> readOnlyIterable(final Iterable<? extends V> iterable, final Function<V, T> conversion) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.readOnly(iterable.iterator(), conversion);
            }
        };
    }

    public static <T> Iterator<T> join(Iterable<T> first, T last) {
        return Iterators.join(first.iterator(), Iterators.with(last));
    }

    public static <T> Iterator<T> join(Iterable<T> first, T last1, T last2) {
        return Iterators.join(first.iterator(), Iterators.with(last1, last2));
    }

    public static <T> Iterator<T> join(Iterable<T> first, T last1, T last2, T last3) {
        return Iterators.join(first.iterator(), Iterators.with(last1, last2, last3));
    }

    public static <T> Iterator<T> join(Iterable<T> first, T last1, T last2, T last3, T last4) {
        return Iterators.join(first.iterator(), Iterators.with(last1, last2, last3, last4));
    }

    public static <T> Iterator<T> join(Iterable<T> first, Iterable<T> second) {
        return Iterators.join(first.iterator(), second.iterator());
    }

    public static <T> Iterator<T> join(final Iterator<T> first, final Iterator<T> second) {
        return new Iterator<T>(){
            private boolean completedFirst = false;

            @Override
            public boolean hasNext() {
                if (!this.completedFirst) {
                    if (first.hasNext()) {
                        return true;
                    }
                    this.completedFirst = true;
                }
                return second.hasNext();
            }

            @Override
            public T next() {
                if (!this.completedFirst) {
                    if (first.hasNext()) {
                        return first.next();
                    }
                    this.completedFirst = true;
                }
                return second.next();
            }

            @Override
            public void remove() {
                if (!this.completedFirst) {
                    first.remove();
                }
                second.remove();
            }
        };
    }

    public static <T> Iterable<T> toIterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <F, T> Iterator<T> transform(final Iterator<F> fromIterator, final Function<? super F, ? extends T> function) {
        return new TransformedIterator<F, T>(){

            @Override
            public boolean hasNext() {
                return fromIterator.hasNext();
            }

            @Override
            public T next() {
                return this.transform(fromIterator.next());
            }

            @Override
            public void remove() {
                fromIterator.remove();
            }

            @Override
            public T transform(F from) {
                return function.apply(from);
            }
        };
    }

    public static <T> PreviewIterator<T> preview(final Iterator<T> iter) {
        if (iter == null) {
            return null;
        }
        if (iter instanceof PreviewIterator) {
            return (PreviewIterator)iter;
        }
        return new PreviewIterator<T>(){
            private T nextValue;

            @Override
            public boolean hasNext() {
                return this.nextValue != null || iter.hasNext();
            }

            @Override
            public T next() {
                if (this.nextValue != null) {
                    Object next = this.nextValue;
                    this.nextValue = null;
                    return next;
                }
                return iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T peek() {
                if (this.nextValue != null) {
                    return this.nextValue;
                }
                if (iter.hasNext()) {
                    this.nextValue = iter.next();
                    return this.nextValue;
                }
                return null;
            }
        };
    }

    public static interface PreviewIterator<T>
    extends Iterator<T> {
        public T peek();
    }

    public static interface TransformedIterator<F, T>
    extends Iterator<T> {
        public T transform(F var1);
    }
}

