/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class FunctionalReadWriteLock {
    private final ReadWriteLock lock;

    public static FunctionalReadWriteLock reentrant() {
        return FunctionalReadWriteLock.create(new ReentrantReadWriteLock());
    }

    public static FunctionalReadWriteLock create(ReadWriteLock lock) {
        assert (lock != null);
        return new FunctionalReadWriteLock(lock);
    }

    protected FunctionalReadWriteLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    public <T> T read(Supplier<T> operation) {
        try {
            this.lock.readLock().lock();
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void read(Runnable operation) {
        try {
            this.lock.readLock().lock();
            operation.run();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T> T write(Supplier<T> operation) {
        try {
            this.lock.writeLock().lock();
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void write(Runnable operation) {
        try {
            this.lock.writeLock().lock();
            operation.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

