/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util;

import java.time.Duration;
import java.util.function.BooleanSupplier;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;

@FunctionalInterface
public interface ElapsedTimeStrategy {
    public boolean hasElapsed();

    public static ElapsedTimeStrategy none() {
        return () -> true;
    }

    public static ElapsedTimeStrategy constant(final Clock clock, final long delayInMilliseconds) {
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        return new ElapsedTimeStrategy(){
            private long nextTimestamp = 0L;

            @Override
            public boolean hasElapsed() {
                if (this.nextTimestamp == 0L) {
                    this.nextTimestamp = clock.currentTimeInMillis() + delayInMilliseconds;
                    return true;
                }
                long current = clock.currentTimeInMillis();
                if (current >= this.nextTimestamp) {
                    do {
                        long multiple = 1L + (current - this.nextTimestamp) / delayInMilliseconds;
                        this.nextTimestamp += multiple * delayInMilliseconds;
                    } while (current > this.nextTimestamp);
                    return true;
                }
                return false;
            }
        };
    }

    public static ElapsedTimeStrategy constant(Clock clock, Duration delay) {
        return ElapsedTimeStrategy.constant(clock, delay.toMillis());
    }

    public static ElapsedTimeStrategy step(final Clock clock, final long preStepDelayInMilliseconds, final BooleanSupplier stepFunction, final long postStepDelayInMilliseconds) {
        if (preStepDelayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Pre-step delay must be positive");
        }
        if (postStepDelayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Post-step delay must be positive");
        }
        return new ElapsedTimeStrategy(){
            private long nextTimestamp = 0L;
            private boolean elapsed = false;
            private long delta = 0L;

            @Override
            public boolean hasElapsed() {
                long current;
                if (this.nextTimestamp == 0L) {
                    this.elapsed = stepFunction.getAsBoolean();
                    this.delta = this.elapsed ? postStepDelayInMilliseconds : preStepDelayInMilliseconds;
                    this.nextTimestamp = clock.currentTimeInMillis() + this.delta;
                    return true;
                }
                if (!this.elapsed) {
                    this.elapsed = stepFunction.getAsBoolean();
                    if (this.elapsed) {
                        this.delta = postStepDelayInMilliseconds;
                    }
                }
                if ((current = clock.currentTimeInMillis()) >= this.nextTimestamp) {
                    do {
                        assert (this.delta > 0L);
                        long multiple = 1L + (current - this.nextTimestamp) / this.delta;
                        this.nextTimestamp += multiple * this.delta;
                    } while (this.nextTimestamp <= current);
                    return true;
                }
                return false;
            }
        };
    }

    public static ElapsedTimeStrategy linear(final Clock clock, final long delayInMilliseconds) {
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        return new ElapsedTimeStrategy(){
            private long nextTimestamp = 0L;
            private long counter = 1L;

            @Override
            public boolean hasElapsed() {
                if (this.nextTimestamp == 0L) {
                    this.nextTimestamp = clock.currentTimeInMillis() + delayInMilliseconds;
                    this.counter = 1L;
                    return true;
                }
                long current = clock.currentTimeInMillis();
                if (current >= this.nextTimestamp) {
                    do {
                        if (this.counter < Long.MAX_VALUE) {
                            ++this.counter;
                        }
                        this.nextTimestamp += delayInMilliseconds * this.counter;
                    } while (this.nextTimestamp <= current);
                    return true;
                }
                return false;
            }
        };
    }

    public static ElapsedTimeStrategy exponential(Clock clock, long initialDelayInMilliseconds, long maxDelayInMilliseconds) {
        return ElapsedTimeStrategy.exponential(clock, initialDelayInMilliseconds, maxDelayInMilliseconds, 2.0);
    }

    public static ElapsedTimeStrategy exponential(final Clock clock, final long initialDelayInMilliseconds, final long maxDelayInMilliseconds, final double multiplier) {
        if (multiplier <= 1.0) {
            throw new IllegalArgumentException("Multiplier must be greater than 1");
        }
        if (initialDelayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Initial delay must be positive");
        }
        if (initialDelayInMilliseconds >= maxDelayInMilliseconds) {
            throw new IllegalArgumentException("Maximum delay must be greater than initial delay");
        }
        return new ElapsedTimeStrategy(){
            private long nextTimestamp = 0L;
            private long previousDelay = 0L;

            @Override
            public boolean hasElapsed() {
                if (this.nextTimestamp == 0L) {
                    this.nextTimestamp = clock.currentTimeInMillis() + initialDelayInMilliseconds;
                    this.previousDelay = initialDelayInMilliseconds;
                    return true;
                }
                long current = clock.currentTimeInMillis();
                if (current >= this.nextTimestamp) {
                    do {
                        long nextDelay;
                        if ((nextDelay = (long)((double)this.previousDelay * multiplier)) >= maxDelayInMilliseconds) {
                            this.previousDelay = maxDelayInMilliseconds;
                            if (this.nextTimestamp < current) {
                                long multiple = 1L + (current - this.nextTimestamp) / maxDelayInMilliseconds;
                                this.nextTimestamp += multiple * maxDelayInMilliseconds;
                            }
                        } else {
                            this.previousDelay = nextDelay;
                        }
                        this.nextTimestamp += this.previousDelay;
                    } while (this.nextTimestamp <= current);
                    return true;
                }
                return false;
            }
        };
    }
}

