/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util;

import java.time.Instant;
import java.util.concurrent.TimeUnit;

public interface Clock {
    public static final Clock SYSTEM = new Clock(){

        @Override
        public long currentTimeInMillis() {
            return System.currentTimeMillis();
        }

        @Override
        public long currentTimeInNanos() {
            return System.nanoTime();
        }

        @Override
        public Instant currentTimeAsInstant() {
            return Instant.now();
        }
    };

    public static Clock system() {
        return SYSTEM;
    }

    default public Instant currentTime() {
        return Instant.ofEpochMilli(this.currentTimeInMillis());
    }

    default public long currentTimeInNanos() {
        return this.currentTimeInMillis() * 1000000L;
    }

    default public long currentTimeInMicros() {
        return TimeUnit.MICROSECONDS.convert(this.currentTimeInMillis(), TimeUnit.MILLISECONDS);
    }

    default public Instant currentTimeAsInstant() {
        return Instant.ofEpochMilli(this.currentTimeInMillis());
    }

    public long currentTimeInMillis();
}

