/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjuster;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time.Conversions;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;

public class Timestamp {
    public static final String SCHEMA_NAME = "org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time.Timestamp";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return Timestamp.builder().build();
    }

    public static long toEpochMillis(Object value, TemporalAdjuster adjuster) {
        if (value instanceof Long) {
            return (Long)value;
        }
        LocalDateTime dateTime = Conversions.toLocalDateTime(value);
        if (adjuster != null) {
            dateTime = dateTime.with(adjuster);
        }
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private Timestamp() {
    }
}

