/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time;

import java.time.Duration;
import java.time.LocalTime;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time.Conversions;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;

public class Time {
    public static final String SCHEMA_NAME = "org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.time.Time";
    private static final Duration ONE_DAY = Duration.ofDays(1L);

    public static SchemaBuilder builder() {
        return SchemaBuilder.int32().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return Time.builder().build();
    }

    public static int toMilliOfDay(Object value, boolean acceptLargeValues) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            if (!acceptLargeValues && (duration.isNegative() || duration.compareTo(ONE_DAY) > 0)) {
                throw new IllegalArgumentException("Time values must be between 00:00:00 and 24:00:00 (inclusive): " + duration);
            }
            return (int)((Duration)value).toMillis();
        }
        LocalTime time = Conversions.toLocalTime(value);
        long micros = Math.floorDiv(time.toNanoOfDay(), Conversions.NANOSECONDS_PER_MILLISECOND);
        assert (Math.abs(micros) < Integer.MAX_VALUE);
        return (int)micros;
    }

    private Time() {
    }
}

