/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.text;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.text.ParsingException;

public class MultipleParsingExceptions
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Collection<ParsingException> errors;

    public MultipleParsingExceptions(Collection<ParsingException> errors) {
        this("Multiple parsing errors", errors);
    }

    public MultipleParsingExceptions(String message, Collection<ParsingException> errors) {
        super(message);
        this.errors = Collections.unmodifiableCollection(errors);
    }

    public Collection<ParsingException> getErrors() {
        return this.errors;
    }

    public void forEachError(Consumer<ParsingException> action) {
        this.errors.forEach(action);
    }

    @Override
    public void printStackTrace() {
        this.forEachError(Throwable::printStackTrace);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.forEachError(e -> e.printStackTrace(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.forEachError(e -> e.printStackTrace(s));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        this.forEachError(e -> sb.append(System.lineSeparator()).append(e.toString()));
        return sb.toString();
    }
}

