/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.TableChanges;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;

public class SchemaChangeEvent {
    private final String database;
    private final String schema;
    private final String ddl;
    private final Set<Table> tables;
    private final SchemaChangeEventType type;
    private final Map<String, ?> partition;
    private final Map<String, ?> offset;
    private final Struct source;
    private final boolean isFromSnapshot;
    private TableChanges tableChanges = new TableChanges();

    public SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Table table, SchemaChangeEventType type, boolean isFromSnapshot) {
        this(partition, offset, source, database, schema, ddl, table != null ? Collections.singleton(table) : Collections.emptySet(), type, isFromSnapshot);
    }

    public SchemaChangeEvent(Map<String, ?> partition, Map<String, ?> offset, Struct source, String database, String schema, String ddl, Set<Table> tables, SchemaChangeEventType type, boolean isFromSnapshot) {
        this.partition = Objects.requireNonNull(partition, "partition must not be null");
        this.offset = Objects.requireNonNull(offset, "offset must not be null");
        this.source = Objects.requireNonNull(source, "source must not be null");
        this.database = Objects.requireNonNull(database, "database must not be null");
        this.schema = schema;
        this.ddl = ddl;
        this.tables = Objects.requireNonNull(tables, "tables must not be null");
        this.type = Objects.requireNonNull(type, "type must not be null");
        this.isFromSnapshot = isFromSnapshot;
        switch (type) {
            case CREATE: {
                tables.forEach(this.tableChanges::create);
                break;
            }
            case ALTER: {
                tables.forEach(this.tableChanges::alter);
                break;
            }
            case DROP: {
                tables.forEach(this.tableChanges::drop);
                break;
            }
        }
    }

    public Map<String, ?> getPartition() {
        return this.partition;
    }

    public Map<String, ?> getOffset() {
        return this.offset;
    }

    public Struct getSource() {
        return this.source;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDdl() {
        return this.ddl;
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    public SchemaChangeEventType getType() {
        return this.type;
    }

    public boolean isFromSnapshot() {
        return this.isFromSnapshot;
    }

    public TableChanges getTableChanges() {
        return this.tableChanges;
    }

    public String toString() {
        return "SchemaChangeEvent [database=" + this.database + ", schema=" + this.schema + ", ddl=" + this.ddl + ", tables=" + this.tables + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum SchemaChangeEventType {
        CREATE,
        ALTER,
        DROP,
        DATABASE;

    }
}

