/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.ThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.AbstractDatabaseHistory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.HistoryRecord;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.FunctionalReadWriteLock;

@ThreadSafe
public final class MemoryDatabaseHistory
extends AbstractDatabaseHistory {
    private final List<HistoryRecord> records = new ArrayList<HistoryRecord>();
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();

    @Override
    protected void storeRecord(HistoryRecord record) {
        this.lock.write(() -> this.records.add(record));
    }

    @Override
    protected void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> this.records.forEach(records));
    }

    @Override
    public boolean storageExists() {
        return true;
    }

    @Override
    public boolean exists() {
        return !this.records.isEmpty();
    }

    public String toString() {
        return "memory";
    }
}

