/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.Immutable;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.ThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.Envelope;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.SchemaUtil;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.CustomConverterRegistry;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Key;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.StructGenerator;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Tables;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.ValueConverter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.ValueConverterProvider;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.mapping.ColumnMapper;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.mapping.ColumnMappers;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.FieldNameSelector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.SchemaNameAdjuster;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public class TableSchemaBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchemaBuilder.class);
    private final SchemaNameAdjuster schemaNameAdjuster;
    private final ValueConverterProvider valueConverterProvider;
    private final Schema sourceInfoSchema;
    private final FieldNameSelector.FieldNamer<Column> fieldNamer;
    private final CustomConverterRegistry customConverterRegistry;

    public TableSchemaBuilder(ValueConverterProvider valueConverterProvider, SchemaNameAdjuster schemaNameAdjuster, CustomConverterRegistry customConverterRegistry, Schema sourceInfoSchema, boolean sanitizeFieldNames) {
        this.schemaNameAdjuster = schemaNameAdjuster;
        this.valueConverterProvider = valueConverterProvider;
        this.sourceInfoSchema = sourceInfoSchema;
        this.fieldNamer = FieldNameSelector.defaultSelector(sanitizeFieldNames);
        this.customConverterRegistry = customConverterRegistry;
    }

    public TableSchema create(String schemaPrefix, String envelopSchemaName, Table table, Tables.ColumnNameFilter filter, ColumnMappers mappers, Key.KeyMapper keysMapper) {
        Schema keySchema;
        if (schemaPrefix == null) {
            schemaPrefix = "";
        }
        TableId tableId = table.id();
        String tableIdStr = this.tableSchemaName(tableId);
        String schemaNamePrefix = schemaPrefix + tableIdStr;
        LOGGER.debug("Mapping table '{}' to schemas under '{}'", (Object)tableId, (Object)schemaNamePrefix);
        SchemaBuilder valSchemaBuilder = SchemaBuilder.struct().name(this.schemaNameAdjuster.adjust(schemaNamePrefix + ".Value"));
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct().name(this.schemaNameAdjuster.adjust(schemaNamePrefix + ".Key"));
        AtomicBoolean hasPrimaryKey = new AtomicBoolean(false);
        Key tableKey = new Key.Builder(table).customKeyMapper(keysMapper).build();
        tableKey.keyColumns().forEach(column -> {
            this.addField(keySchemaBuilder, table, (Column)column, null);
            hasPrimaryKey.set(true);
        });
        table.columns().stream().filter(column -> filter == null || filter.matches(tableId.catalog(), tableId.schema(), tableId.table(), column.name())).forEach(column -> {
            ColumnMapper mapper = mappers == null ? null : mappers.mapperFor(tableId, (Column)column);
            this.addField(valSchemaBuilder, table, (Column)column, mapper);
        });
        Schema valSchema = valSchemaBuilder.optional().build();
        Schema schema = keySchema = hasPrimaryKey.get() ? keySchemaBuilder.build() : null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mapped primary key for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(keySchema));
            LOGGER.debug("Mapped columns for table '{}' to schema: {}", (Object)tableId, (Object)SchemaUtil.asDetailedString(valSchema));
        }
        Envelope envelope = Envelope.defineSchema().withName(this.schemaNameAdjuster.adjust(envelopSchemaName)).withRecord(valSchema).withSource(this.sourceInfoSchema).build();
        StructGenerator keyGenerator = this.createKeyGenerator(keySchema, tableId, tableKey.keyColumns());
        StructGenerator valueGenerator = this.createValueGenerator(valSchema, tableId, table.columns(), filter, mappers);
        return new TableSchema(tableId, keySchema, keyGenerator, envelope, valSchema, valueGenerator);
    }

    private String tableSchemaName(TableId tableId) {
        if (Strings.isNullOrEmpty(tableId.catalog())) {
            if (Strings.isNullOrEmpty(tableId.schema())) {
                return tableId.table();
            }
            return tableId.schema() + "." + tableId.table();
        }
        if (Strings.isNullOrEmpty(tableId.schema())) {
            return tableId.catalog() + "." + tableId.table();
        }
        return tableId.schema() + "." + tableId.table();
    }

    protected StructGenerator createKeyGenerator(Schema schema, TableId columnSetName, List<Column> columns) {
        if (schema != null) {
            int[] recordIndexes = this.indexesForColumns(columns);
            Field[] fields = this.fieldsForColumns(schema, columns);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, columnSetName, columns, null);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    this.validateIncomingRowToInternalMetadata(recordIndexes, fields, converters, row, i);
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter == null) continue;
                    value = converter.convert(value);
                    try {
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (DataException e) {
                        Column col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert key value for '{}.{}' of type {} for row {}:", new Object[]{columnSetName, col.name(), col.typeName(), row, e});
                    }
                }
                return result;
            };
        }
        return null;
    }

    private void validateIncomingRowToInternalMetadata(int[] recordIndexes, Field[] fields, ValueConverter[] converters, Object[] row, int position) {
        if (position >= converters.length) {
            LOGGER.error("Error requesting a converter, converters: {}, requested index: {}", (Object)converters.length, (Object)position);
            throw new ConnectException("Column indexing array is larger than number of converters, internal schema representation is probably out of sync with real database schema");
        }
        if (position >= fields.length) {
            LOGGER.error("Error requesting a field, fields: {}, requested index: {}", (Object)fields.length, (Object)position);
            throw new ConnectException("Too few schema fields, internal schema representation is probably out of sync with real database schema");
        }
        if (recordIndexes[position] >= row.length) {
            LOGGER.error("Error requesting a row value, row: {}, requested index: {} at position {}", new Object[]{row.length, recordIndexes[position], position});
            throw new ConnectException("Data row is smaller than a column index, internal schema representation is probably out of sync with real database schema");
        }
    }

    protected StructGenerator createValueGenerator(Schema schema, TableId tableId, List<Column> columns, Tables.ColumnNameFilter filter, ColumnMappers mappers) {
        if (schema != null) {
            List<Column> columnsThatShouldBeAdded = columns.stream().filter(column -> filter == null || filter.matches(tableId.catalog(), tableId.schema(), tableId.table(), column.name())).collect(Collectors.toList());
            int[] recordIndexes = this.indexesForColumns(columnsThatShouldBeAdded);
            Field[] fields = this.fieldsForColumns(schema, columnsThatShouldBeAdded);
            int numFields = recordIndexes.length;
            ValueConverter[] converters = this.convertersForColumns(schema, tableId, columnsThatShouldBeAdded, mappers);
            return row -> {
                Struct result = new Struct(schema);
                for (int i = 0; i != numFields; ++i) {
                    Column col;
                    this.validateIncomingRowToInternalMetadata(recordIndexes, fields, converters, row, i);
                    Object value = row[recordIndexes[i]];
                    ValueConverter converter = converters[i];
                    if (converter != null) {
                        LOGGER.trace("converter for value object: *** {} ***", (Object)converter);
                    } else {
                        LOGGER.trace("converter is null...");
                    }
                    if (converter == null) continue;
                    try {
                        value = converter.convert(value);
                        result.put(fields[i], value);
                        continue;
                    }
                    catch (IllegalArgumentException | DataException e) {
                        col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert data value for '{}.{}' of type {} for row {}:", new Object[]{tableId, col.name(), col.typeName(), row, e});
                        continue;
                    }
                    catch (Exception e) {
                        col = (Column)columns.get(i);
                        LOGGER.error("Failed to properly convert data value for '{}.{}' of type {} for row {}:", new Object[]{tableId, col.name(), col.typeName(), row, e});
                    }
                }
                return result;
            };
        }
        return null;
    }

    protected int[] indexesForColumns(List<Column> columns) {
        int[] recordIndexes = new int[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            recordIndexes[i.getAndIncrement()] = column.position() - 1;
        });
        return recordIndexes;
    }

    protected Field[] fieldsForColumns(Schema schema, List<Column> columns) {
        Field[] fields = new Field[columns.size()];
        AtomicInteger i = new AtomicInteger(0);
        columns.forEach(column -> {
            Field field;
            fields[i.getAndIncrement()] = field = schema.field(this.fieldNamer.fieldNameFor((Column)column));
        });
        return fields;
    }

    protected ValueConverter[] convertersForColumns(Schema schema, TableId tableId, List<Column> columns, ColumnMappers mappers) {
        ValueConverter[] converters = new ValueConverter[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            ValueConverter converter = this.createValueConverterFor(tableId, column, schema.field(this.fieldNamer.fieldNameFor(column)));
            if ((converter = this.wrapInMappingConverterIfNeeded(mappers, tableId, column, converter)) == null) {
                LOGGER.warn("No converter found for column {}.{} of type {}. The column will not be part of change events for that table.", new Object[]{tableId, column.name(), column.typeName()});
            }
            converters[i] = converter;
        }
        return converters;
    }

    private ValueConverter wrapInMappingConverterIfNeeded(ColumnMappers mappers, TableId tableId, Column column, ValueConverter converter) {
        if (mappers == null || converter == null) {
            return converter;
        }
        ValueConverter mappingConverter = mappers.mappingConverterFor(tableId, column);
        if (mappingConverter == null) {
            return converter;
        }
        return value -> mappingConverter.convert(converter.convert(value));
    }

    protected void addField(SchemaBuilder builder, Table table, Column column, ColumnMapper mapper) {
        SchemaBuilder fieldBuilder = this.customConverterRegistry.registerConverterFor(table.id(), column).orElse(this.valueConverterProvider.schemaBuilder(column));
        if (fieldBuilder != null) {
            if (mapper != null) {
                mapper.alterFieldSchema(column, fieldBuilder);
            }
            if (column.isOptional()) {
                fieldBuilder.optional();
            }
            if (column.hasDefaultValue()) {
                fieldBuilder.defaultValue(this.customConverterRegistry.getValueConverter(table.id(), column).orElse(ValueConverter.passthrough()).convert(column.defaultValue()));
            }
            builder.field(this.fieldNamer.fieldNameFor(column), fieldBuilder.build());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("- field '{}' ({}{}) from column {}", new Object[]{column.name(), builder.isOptional() ? "OPTIONAL " : "", fieldBuilder.type(), column});
            }
        } else {
            LOGGER.warn("Unexpected JDBC type '{}' for column '{}' that will be ignored", (Object)column.jdbcType(), (Object)column.name());
        }
    }

    protected ValueConverter createValueConverterFor(TableId tableId, Column column, Field fieldDefn) {
        return this.customConverterRegistry.getValueConverter(tableId, column).orElse(this.valueConverterProvider.converter(column, fieldDefn));
    }
}

