/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.NotThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.NoOpTableEditorImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;

@NotThreadSafe
public interface TableEditor {
    public static TableEditor noOp(TableId id) {
        return new NoOpTableEditorImpl().tableId(id);
    }

    public TableId tableId();

    public TableEditor tableId(TableId var1);

    public List<Column> columns();

    default public List<String> columnNames() {
        return this.columns().stream().map(Column::name).collect(Collectors.toList());
    }

    public Column columnWithName(String var1);

    public List<String> primaryKeyColumnNames();

    default public boolean hasPrimaryKey() {
        return !this.primaryKeyColumnNames().isEmpty();
    }

    default public TableEditor addColumn(Column column) {
        return this.addColumns(column);
    }

    public TableEditor addColumns(Column ... var1);

    public TableEditor addColumns(Iterable<Column> var1);

    public TableEditor setColumns(Column ... var1);

    public TableEditor setColumns(Iterable<Column> var1);

    public TableEditor removeColumn(String var1);

    public TableEditor updateColumn(Column var1);

    public TableEditor reorderColumn(String var1, String var2);

    public TableEditor renameColumn(String var1, String var2);

    public TableEditor setPrimaryKeyNames(String ... var1);

    public TableEditor setPrimaryKeyNames(List<String> var1);

    public TableEditor setUniqueValues();

    public TableEditor setDefaultCharsetName(String var1);

    public boolean hasDefaultCharsetName();

    public boolean hasUniqueValues();

    public Table create();
}

