/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.Immutable;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableEditor;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableEditorImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;

@Immutable
public interface Table {
    public static TableEditor editor() {
        return new TableEditorImpl();
    }

    public TableId id();

    public List<String> primaryKeyColumnNames();

    default public List<Column> primaryKeyColumns() {
        List pkColumns = this.primaryKeyColumnNames().stream().map(this::columnWithName).collect(Collectors.toList());
        return Collections.unmodifiableList(pkColumns);
    }

    default public List<Column> filterColumns(Predicate<Column> predicate) {
        return this.columns().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<String> retrieveColumnNames();

    public List<Column> columns();

    public Column columnWithName(String var1);

    public String defaultCharsetName();

    default public boolean isPrimaryKeyColumn(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : this.primaryKeyColumnNames().contains(column.name());
    }

    default public boolean isAutoIncremented(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isAutoIncremented();
    }

    default public boolean isGenerated(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isGenerated();
    }

    default public boolean isOptional(String columnName) {
        Column column = this.columnWithName(columnName);
        return column == null ? false : column.isOptional();
    }

    public TableEditor edit();
}

