/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.Partition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Key;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableSchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Tables;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.ddl.DdlParser;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.DatabaseHistory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.TableChanges;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.HistorizedDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.SchemaChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.TopicSelector;

public abstract class HistorizedRelationalDatabaseSchema
extends RelationalDatabaseSchema
implements HistorizedDatabaseSchema<TableId> {
    protected final DatabaseHistory databaseHistory;
    private boolean recoveredTables;

    protected HistorizedRelationalDatabaseSchema(HistorizedRelationalDatabaseConnectorConfig config, TopicSelector<TableId> topicSelector, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, TableSchemaBuilder schemaBuilder, boolean tableIdCaseInsensitive, Key.KeyMapper customKeysMapper) {
        super(config, topicSelector, tableFilter, columnFilter, schemaBuilder, tableIdCaseInsensitive, customKeysMapper);
        this.databaseHistory = config.getDatabaseHistory();
        this.databaseHistory.start();
    }

    @Override
    public void recover(Partition partition, OffsetContext offset) {
        if (!this.databaseHistory.exists()) {
            String msg = "The db history topic or its content is fully or partially missing. Please check database history topic configuration and re-execute the snapshot.";
            throw new DebeziumException(msg);
        }
        this.databaseHistory.recover(partition.getSourcePartition(), offset.getOffset(), this.tables(), this.getDdlParser());
        this.recoveredTables = !this.tableIds().isEmpty();
        for (TableId tableId : this.tableIds()) {
            this.buildAndRegisterSchema(this.tableFor(tableId));
        }
    }

    @Override
    public void close() {
        this.databaseHistory.stop();
    }

    @Override
    public void initializeStorage() {
        if (!this.databaseHistory.storageExists()) {
            this.databaseHistory.initializeStorage();
        }
    }

    protected abstract DdlParser getDdlParser();

    protected void record(SchemaChangeEvent schemaChange, TableChanges tableChanges) {
        this.databaseHistory.record(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getDatabase(), schemaChange.getSchema(), schemaChange.getDdl(), tableChanges);
    }

    @Override
    public boolean tableInformationComplete() {
        return this.recoveredTables;
    }

    @Override
    public boolean storeOnlyCapturedTables() {
        return this.databaseHistory.storeOnlyCapturedTables();
    }

    @Override
    public boolean isHistorized() {
        return true;
    }
}

